/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine.support;

import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskHisBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.diagram.TaskStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import org.dom4j.Document;
import org.dom4j.Element;

import java.io.Serializable;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;

public class CoreBpmnRuntimeRejectProcessSupport<T extends Auditable<ID>, ID extends Serializable> extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
   protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      int i = 0;

      for(int j = sourceList.size(); i < j; ++i) {
         CoreBpmnRuntimeSource<T, ID> source = (CoreBpmnRuntimeSource)sourceList.get(i);
         SinoConcurrentLocker.isolated(source.getTargetId());
         Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
         if (BpmnDiagramHelper.isCommentRequiredTask(taskElement) && StringUtils.isEmpty(source.getComment())) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_DRAFT.TIP.COMMENT_REQUIRED");
         }

         String rejectValidatorSql = BpmnDiagramHelper.getRejectValidatorSql(taskElement);
         if (!StringUtils.isBlank(rejectValidatorSql)) {
            this.prepareValidateSql(i + 1, rejectValidatorSql, source.getId());
         }

         this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.reject, taskElement, source.getId());
      }

   }

   protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      List<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList();
      List<CoreBpmnInstanceTaskHisBean> filterList = new ArrayList();
      Iterator var4 = sourceList.iterator();

      CoreBpmnRuntimeSource source;
      AtomicReference<CoreBpmnInstanceTaskBean> instanceTask = new AtomicReference<>();
      while(var4.hasNext()) {
         source = (CoreBpmnRuntimeSource)var4.next();
         if (!StringUtils.isEmpty(source.getTargetStatusCode()) && !ProcessStatus.DRAFT.name().equalsIgnoreCase(source.getTargetStatusCode())) {
            CoreBpmnInstanceTaskHisBean filter = new CoreBpmnInstanceTaskHisBean();
            instanceTask.set(BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source));
            filter.setInstId(instanceTask.get().getInstId());
            filter.setStatusCode(source.getTargetStatusCode());
            filterList.add(filter);
         }
      }

      if (!filterList.isEmpty()) {
         List<CoreBpmnInstanceTaskHisBean> taskHisList = this.taskHisService.selectLatestTaskHisList(filterList);
         if (!taskHisList.isEmpty()) {
            Map<ID, CoreBpmnInstanceTaskHisBean> taskHisMap = new HashMap();
            Iterator var15 = taskHisList.iterator();

            while(var15.hasNext()) {
               CoreBpmnInstanceTaskHisBean taskHis = (CoreBpmnInstanceTaskHisBean)var15.next();
               source = (CoreBpmnRuntimeSource)sourceList.stream().filter((s) -> {
                  if (!s.getTargetStatusCode().equals(taskHis.getStatusCode())) {
                     return false;
                  } else {
                     instanceTask.set(BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(s));
                     return taskHis.getInstId().equals(instanceTask.get().getInstId());
                  }
               }).findAny().orElse(null);
               if (source != null) {
                  taskHisMap.put((ID) source.getId(), taskHis);
               }
            }

            BpmnRuntimeCacheProvider.cacheBpmnRuntimeTaskHisMap(taskHisMap);
         }
      }

      var4 = sourceList.iterator();

      while(var4.hasNext()) {
         source = (CoreBpmnRuntimeSource)var4.next();
         CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
         source.setRuntimeInitiator(instance.getInitiator());
         source.setRuntimeProcId(instance.getProcId());
         instanceTask.set(BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source));
         Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source);
         Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
         CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO();
         if (!StringUtils.isEmpty(source.getTargetStatusCode()) && !ProcessStatus.DRAFT.name().equalsIgnoreCase(source.getTargetStatusCode())) {
            this.rejectTask(diagram, instance, instanceTask.get(), BpmnRuntimeCacheProvider.getBpmnRuntimeUnlimitedInstanceTaskList(), source);
            instanceStatus.setId((ID) source.getId());
            instanceStatus.setProcessStatus(ProcessStatus.APPROVE_REJECTED);
            instanceStatus.setStatusCode(instanceTask.get().getStatusCode());
            instanceStatus.setNextStatusCode(source.getTargetStatusCode());
            instanceStatusList.add(instanceStatus);
            BpmnRuntimeCacheProvider.getProcessData().addUpdateProcessStatusBpmnTarget(this.getBpmnTarget(source, ProcessStatus.APPROVE_REJECTED));
         } else {
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
            instanceStatus.setId((ID) source.getId());
            instanceStatus.setProcessStatus(ProcessStatus.DRAFT_REJECTED);
            instanceStatus.setStatusCode(instanceTask.get().getStatusCode());
            instanceStatusList.add(instanceStatus);
            BpmnRuntimeCacheProvider.getProcessData().addDeleteBpmnTargetIdList(source.getTargetId());
         }

         if (StringUtils.isEmpty(source.getComment())) {
            source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.REJECT"));
         }

         String sourceName = XmlUtils.getAttributeValue(taskElement, "name");
         String targetName = instanceStatus.getNextStatusCode() == null ? I18nHelper.getMessage("SINO.BPMN.TASK.START") : XmlUtils.getAttributeValue(BpmnDiagramHelper.getProcessElementByStatusCode(diagram, instanceStatus.getNextStatusCode()), "name");
         this.insertComment(instance.getTargetId(), taskElement, CommentStatus.REJECT, source, this.getRoute(sourceName, targetName));
         BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskId(instanceTask.get().getId());
      }

      return instanceStatusList;
   }

   private void rejectTask(Document diagram, CoreBpmnInstanceBean instance, CoreBpmnInstanceTaskBean task, List<CoreBpmnInstanceTaskBean> instanceTaskUnlimitedList, CoreBpmnRuntimeSource<T, ID> source) {
      CoreBpmnInstanceTaskBean instanceTask = new CoreBpmnInstanceTaskBean();
      instanceTask.setId(task.getId());
      instanceTask.setStatus(TaskStatus.REJECTED.name());
      BpmnRuntimeCacheProvider.getProcessData().addUpdateInstanceTaskStatus(instanceTask);
      BpmnRuntimeCacheProvider.getProcessData().addDeleteCandidatorInstanceTaskId(task.getId());
      Iterator var7 = instanceTaskUnlimitedList.iterator();

      while(var7.hasNext()) {
         CoreBpmnInstanceTaskBean instanceTaskUnlimited = (CoreBpmnInstanceTaskBean)var7.next();
         if (!task.getId().equals(instanceTaskUnlimited.getId())) {
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskId(instanceTaskUnlimited.getId());
         }
      }

      Element targetElement = BpmnDiagramHelper.getProcessElementByStatusCode(diagram, source.getTargetStatusCode());
      this.insertNextInstanceTask(diagram, instance, Arrays.asList(targetElement), source);
   }
}
