/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine.support;

import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.utils.XmlUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.diagram.CommentStatus;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class CoreBpmnRuntimeOddRejectProcessSupport<T extends Auditable<ID>, ID extends Serializable> extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
   protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
   }

   protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      sourceList.forEach((s) -> {
         s.setRuntimeCheckPermission(false);
      });
      List<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList();
      Iterator var3 = sourceList.iterator();

      while(var3.hasNext()) {
         CoreBpmnRuntimeSource<T, ID> source = (CoreBpmnRuntimeSource)var3.next();
         SinoConcurrentLocker.isolated(source.getTargetId());
         CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
         source.setRuntimeInitiator(instance.getInitiator());
         source.setRuntimeProcId(instance.getProcId());
         BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
         CoreBpmnInstanceTaskBean instanceTask = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source);
         Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
         CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO();
         instanceStatus.setId(source.getId());
         instanceStatus.setProcessStatus(ProcessStatus.DRAFT_REJECTED);
         instanceStatusList.add(instanceStatus);
         BpmnRuntimeCacheProvider.getProcessData().addDeleteBpmnTargetIdList(source.getTargetId());
         if (StringUtils.isEmpty(source.getComment())) {
            source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.REJECT"));
         }

         String sourceName = XmlUtils.getAttributeValue(taskElement, "name");
         String targetName = I18nHelper.getMessage("SINO.BPMN.TASK.START");
         this.insertComment(instance.getTargetId(), (Element)null, CommentStatus.REJECT, source, this.getRoute(sourceName, targetName));
         this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.reject, taskElement, source.getId());
         BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskId(instanceTask.getId());
      }

      return instanceStatusList;
   }
}
