/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine.support;

import net.sinodawn.framework.context.concurrent.SinoConcurrentLocker;
import net.sinodawn.framework.data.Pair;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import net.sinodawn.module.sys.bpmn.diagram.ProcessElementType;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.diagram.TaskStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class CoreBpmnRuntimeCompleteProcessSupport<T extends Auditable<ID>, ID extends Serializable> extends AbstractCoreBpmnRuntimeProcessSupport<T, ID> {
   private static final Logger logger = LoggerFactory.getLogger(CoreBpmnRuntimeCompleteProcessSupport.class);

   protected void doValidate(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      int i = 0;

      for(int j = sourceList.size(); i < j; ++i) {
         CoreBpmnRuntimeSource<T, ID> source = sourceList.get(i);
         SinoConcurrentLocker.isolated(source.getTargetId());
         Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
         if (BpmnDiagramHelper.isCommentRequiredTask(taskElement) && StringUtils.isEmpty(source.getComment())) {
            throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_DRAFT.TIP.COMMENT_REQUIRED");
         }

         String passValidatorSql = BpmnDiagramHelper.getPassValidatorSql(taskElement);
         if (!StringUtils.isBlank(passValidatorSql)) {
            this.prepareValidateSql(i + 1, passValidatorSql, source.getId());
         }

         this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.pass, taskElement, source.getId());
      }

   }

   // TODO
   protected List<CoreBpmnInstanceStatusDTO<ID>> doProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
//      List<CoreBpmnInstanceStatusDTO<ID>> instanceStatusList = new ArrayList();
//      Iterator var3 = sourceList.iterator();
//
//      while(true) {
//         while(var3.hasNext()) {
//            CoreBpmnRuntimeSource<T, ID> source = (CoreBpmnRuntimeSource)var3.next();
//            CoreBpmnInstanceBean instance = BpmnRuntimeCacheProvider.getBpmnRuntimeInstance(source);
//            source.setRuntimeInitiator(instance.getInitiator());
//            source.setRuntimeProcId(instance.getProcId());
//            CoreBpmnInstanceTaskBean instanceTask = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceTask(source);
//            Element taskElement = BpmnRuntimeCacheProvider.getBpmnRuntimeTaskElement(source);
//            List<String> previousTaskAuditedByList = BpmnRuntimeCacheProvider.getBpmnPreviousTaskAuditedByList(source);
//            CounterSignStrategy counterSignStrategy = BpmnDiagramHelper.getCounterSignStrategy(taskElement);
//            String sourceName;
//            if (!CounterSignStrategy.none.equals(counterSignStrategy)) {
//               List instanceCandidatorList = BpmnRuntimeCacheProvider.getBpmnRuntimeInstanceCandidatorList();
//               List instanceTaskCandidatorList;
//               if (CounterSignStrategy.all.equals(counterSignStrategy)) {
//                  instanceTaskCandidatorList = instanceCandidatorList.stream().filter((a) -> {
//                     return instanceTask.getId().equals(a.getInstTaskId());
//                  }).collect(Collectors.toList());
//                  List<CoreBpmnInstanceCandidatorDTO> deleteInstanceTaskCandidatorList;
//                  if (CandidatorFilterStrategy.sameDept.equals(BpmnDiagramHelper.getCandidatorFilterStrategy(taskElement))) {
//                     String createdByOrgId = (String)CollectionUtils.getValueIgnorecase(source.getVars(), "createdByOrgId");
//                     if (!StringUtils.isBlank(createdByOrgId)) {
//                        CoreUserService userService = ApplicationContextHelper.getBean(CoreUserService.class);
//                        deleteInstanceTaskCandidatorList = userService.selectListByIds((List)instanceTaskCandidatorList.stream().map((c) -> {
//                           return c.getId();
//                        }).collect(Collectors.toList()));
//                        List finalDeleteInstanceTaskCandidatorList = deleteInstanceTaskCandidatorList;
//                        instanceTaskCandidatorList.removeIf((c) -> {
//                           return finalDeleteInstanceTaskCandidatorList.stream().filter((s) -> {
//                              return s.getId().equals(c.getCandidatorId());
//                           }).noneMatch((s) -> {
//                              return createdByOrgId.equals(s.getOrgId());
//                           });
//                        });
//                        if (instanceTaskCandidatorList.stream().noneMatch((c) -> {
//                           return c.getCandidatorId().equals(LocalContextHelper.getLoginUserId());
//                        })) {
//                           throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.NOT_AUTHORIZED");
//                        }
//                     } else {
//                        logger.warn("No createdByOrgId column in (" + source.getTableName() + "), ignore candidator filter strategy.");
//                     }
//                  }
//
//                  long otherCandidatorQty = instanceTaskCandidatorList.stream().filter((a) -> {
//                     return !LocalContextHelper.getLoginUserId().equals(a.getCandidatorId()) && (previousTaskAuditedByList.isEmpty() || !previousTaskAuditedByList.contains(a.getCandidatorId()));
//                  }).count();
//                  if (otherCandidatorQty > 0L) {
//                     deleteInstanceTaskCandidatorList = (List)instanceTaskCandidatorList.stream().filter((a) -> {
//                        return LocalContextHelper.getLoginUserId().equals(a.getCandidatorId());
//                     }).collect(Collectors.toList());
//                     Iterator var15 = deleteInstanceTaskCandidatorList.iterator();
//
//                     while(var15.hasNext()) {
//                        CoreBpmnInstanceCandidatorDTO deleteInstanceTaskCandidator = (CoreBpmnInstanceCandidatorDTO)var15.next();
//                        if (deleteInstanceTaskCandidator.getTaskUserId() != null) {
//                           BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskUserId(Arrays.asList(deleteInstanceTaskCandidator.getTaskUserId()));
//                        } else if (deleteInstanceTaskCandidator.getTaskRoleId() != null && instanceTaskCandidatorList.stream().filter((a) -> {
//                           return !LocalContextHelper.getLoginUserId().equals(a.getCandidatorId()) && a.getTaskRoleId() != null;
//                        }).count() == 0L) {
//                           BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskRoleId(Arrays.asList(deleteInstanceTaskCandidator.getTaskRoleId()));
//                        }
//                     }
//
//                     if (StringUtils.isEmpty(source.getComment())) {
//                        source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.PASS_COUNTERSIGN"));
//                     }
//
//                     CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO();
//                     instanceStatus.setId(source.getId());
//                     instanceStatus.setProcessStatus(ProcessStatus.APPROVE);
//                     instanceStatus.setStatusCode(instanceTask.getStatusCode());
//                     instanceStatusList.add(instanceStatus);
//                     String sourceName = XmlUtils.getAttributeValue(taskElement, "name");
//                     this.insertComment(instance.getTargetId(), taskElement, CommentStatus.CS_APPROVE, source, this.getRoute(sourceName, sourceName));
//                     BpmnRuntimeCacheProvider.removeBpmnRuntimeCallback(source.getId());
//                     continue;
//                  }
//               } else if (CounterSignStrategy.role.equals(counterSignStrategy)) {
//                  instanceTaskCandidatorList = (List)instanceCandidatorList.stream().filter((a) -> {
//                     return instanceTask.getId().equals(a.getInstTaskId());
//                  }).collect(Collectors.toList());
//                  if (instanceTaskCandidatorList.stream().anyMatch((c) -> {
//                     return c.getTaskUserId() != null;
//                  })) {
//                     throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_DRAFT.TIP.ROLE_COUNTER_SIGN.REQUIRES_ROLE_ONLY");
//                  }
//
//                  if (instanceTaskCandidatorList.stream().map((c) -> {
//                     return c.getTaskRoleId();
//                  }).distinct().count() > 1L) {
//                     List<Long> deleteTaskRoleIdList = (List)instanceTaskCandidatorList.stream().filter((c) -> {
//                        return LocalContextHelper.getLoginUserId().equals(c.getCandidatorId());
//                     }).map((c) -> {
//                        return c.getTaskRoleId();
//                     }).distinct().collect(Collectors.toList());
//                     BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskRoleId(deleteTaskRoleIdList);
//                     if (StringUtils.isEmpty(source.getComment())) {
//                        source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.PASS_COUNTERSIGN_ROLE"));
//                     }
//
//                     CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO();
//                     instanceStatus.setId(source.getId());
//                     instanceStatus.setProcessStatus(ProcessStatus.APPROVE);
//                     instanceStatus.setStatusCode(instanceTask.getStatusCode());
//                     instanceStatusList.add(instanceStatus);
//                     sourceName = XmlUtils.getAttributeValue(taskElement, "name");
//                     this.insertComment(instance.getTargetId(), taskElement, CommentStatus.CS_APPROVE, source, this.getRoute(sourceName, sourceName));
//                     BpmnRuntimeCacheProvider.removeBpmnRuntimeCallback(source.getId());
//                     continue;
//                  }
//               }
//            }
//
//            Document diagram = BpmnRuntimeCacheProvider.getBpmnRuntimeDocument(source);
//            Pair<ProcessStatus, String> result = this.completeTask(diagram, instance, instanceTask, source);
//            CoreBpmnInstanceStatusDTO<ID> instanceStatus = new CoreBpmnInstanceStatusDTO();
//            instanceStatus.setId(source.getId());
//            instanceStatus.setProcessStatus((ProcessStatus)result.getFirst());
//            instanceStatus.setStatusCode(instanceTask.getStatusCode());
//            if (!ProcessStatus.DONE.equals(result.getFirst())) {
//               instanceStatus.setNextStatusCode((String)result.getSecond());
//            }
//
//            instanceStatusList.add(instanceStatus);
//            if (ProcessStatus.DONE.equals(result.getFirst())) {
//               if (StringUtils.isEmpty(source.getComment())) {
//                  source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.END"));
//               }
//
//               sourceName = XmlUtils.getAttributeValue(taskElement, "name");
//               sourceName = I18nHelper.getMessage("SINO.BPMN.TASK.END");
//               this.insertComment(instance.getTargetId(), taskElement, CommentStatus.APPROVED, source, this.getRoute(sourceName, sourceName));
//               Element endEventElement = BpmnDiagramHelper.getProcessElement(diagram, ProcessElementType.END_EVENT);
//               this.prepareCallback(AbstractCoreBpmnRuntimeProcessSupport.CallbackCategory.end, endEventElement, source.getId());
//            } else {
//               sourceName = XmlUtils.getAttributeValue(taskElement, "name");
//               sourceName = this.getElementName(diagram, instanceStatus.getNextStatusCode());
//               if (!CounterSignStrategy.none.equals(counterSignStrategy)) {
//                  if (StringUtils.isEmpty(source.getComment())) {
//                     source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.END_COUNTERSIGN"));
//                  }
//
//                  this.insertComment(instance.getTargetId(), taskElement, CommentStatus.CS_END, source, this.getRoute(sourceName, sourceName));
//               } else {
//                  if (StringUtils.isEmpty(source.getComment())) {
//                     source.setComment(I18nHelper.getMessage("SINO.BPMN.COMMENT.PASS"));
//                  }
//
//                  this.insertComment(instance.getTargetId(), taskElement, CommentStatus.APPROVE, source, this.getRoute(sourceName, sourceName));
//               }
//            }
//
//            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstanceTaskId(instanceTask.getId());
//            if (ProcessStatus.DONE.equals(result.getFirst())) {
//               BpmnRuntimeCacheProvider.getProcessData().addDeleteBpmnTargetIdList(source.getTargetId());
//            } else {
//               BpmnRuntimeCacheProvider.getProcessData().addInsertOrUpdateBpmnTarget(this.getBpmnTarget(source, (ProcessStatus)result.getFirst()));
//            }
//         }
//
//         return instanceStatusList;
//      }
       return new ArrayList<>();
   }

   private Pair<ProcessStatus, String> completeTask(Document diagram, CoreBpmnInstanceBean instance, CoreBpmnInstanceTaskBean task, CoreBpmnRuntimeSource<T, ID> source) {
      CoreBpmnInstanceTaskBean instanceTask = new CoreBpmnInstanceTaskBean();
      instanceTask.setId(task.getId());
      instanceTask.setStatus(TaskStatus.COMPLETED.name());
      BpmnRuntimeCacheProvider.getProcessData().addUpdateInstanceTaskStatus(instanceTask);
      if (task.getId() != null) {
         BpmnRuntimeCacheProvider.getProcessData().addDeleteCandidatorInstanceTaskId(task.getId());
      }

      List<Element> nextTaskElementList = BpmnRuntimeCacheProvider.getNextTask(source).getNextTaskElementList();
      if (!nextTaskElementList.isEmpty()) {
         if (nextTaskElementList.stream().anyMatch((t) -> {
            return ProcessElementType.END_EVENT.equals(BpmnDiagramHelper.getProcessElementType(t));
         })) {
            BpmnRuntimeCacheProvider.getProcessData().addDeleteInstance(instance);
            return Pair.of(ProcessStatus.DONE, null);
         }

         this.insertNextInstanceTask(diagram, instance, nextTaskElementList, source);
      } else {
         List<Element> sequenceFlowList = BpmnDiagramHelper.getOutgoingSequenceFlowList(diagram, task.getTaskId());
         if (sequenceFlowList.size() != 1) {
            throw new BpmnException("SINO.BPMN.TIP.NEXT_TASK_NOT_FOUND");
         }

         Element sequenceFlow = (Element)sequenceFlowList.get(0);
         Element targetElement = BpmnDiagramHelper.getTargetElement(diagram, sequenceFlow);
         ProcessElementType targetElementType = BpmnDiagramHelper.getProcessElementType(targetElement);
         if (!ProcessElementType.PARALLEL_GATEWAY.equals(targetElementType)) {
            throw new BpmnException("SINO.BPMN.TIP.NEXT_TASK_NOT_FOUND");
         }

         if (BpmnDiagramHelper.getIncomingSequenceFlowIdList(diagram, targetElement).size() <= 1) {
            throw new BpmnException("SINO.BPMN.TIP.NEXT_TASK_NOT_FOUND");
         }
      }

      String nextStatusCode = (String)nextTaskElementList.stream().map((t) -> {
         return BpmnDiagramHelper.getUserTaskStatusCode(t);
      }).collect(Collectors.joining(","));
      return Pair.of(ProcessStatus.APPROVE, nextStatusCode);
   }
}
