/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine.impl;

import com.alibaba.fastjson.JSON;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.executor.ExecutorHelper;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.support.PersistableMetadataHelper;
import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.utils.BeanUtils;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import net.sinodawn.module.sys.bpmn.bean.*;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeService;
import net.sinodawn.module.sys.bpmn.engine.CoreBpmnRuntimeSource;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeCacheProvider;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeData;
import net.sinodawn.module.sys.bpmn.engine.support.*;
import net.sinodawn.module.sys.bpmn.exception.BpmnException;
import net.sinodawn.module.sys.bpmn.service.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

@Repository
public class CoreBpmnRuntimeServiceImpl implements CoreBpmnRuntimeService {
   @Autowired
   private CoreBpmnProcService procService;
   @Autowired
   private CoreBpmnInstanceService instanceService;
   @Autowired
   private CoreBpmnInstanceTaskService instanceTaskService;
   @Autowired
   private CoreBpmnInstanceTaskUserService instanceTaskUserService;
   @Autowired
   private CoreBpmnInstanceTaskRoleService instanceTaskRoleService;
   @Autowired
   private CoreBpmnCommentService commentService;
   @Autowired
   private CoreBpmnTargetService bpmnTargetService;
   @Autowired
   private CoreBpmnInstanceTaskHisService taskHisService;

   @Transactional(
      timeout = 300
   )
   public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> startProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      CoreBpmnRuntimeStartProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeStartProcessSupport();
      return processSupport.apply(sourceList);
   }

   @Transactional(
      timeout = 300
   )
   public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> withdrawProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      CoreBpmnRuntimeWithdrawProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeWithdrawProcessSupport();
      return processSupport.apply(sourceList);
   }

   @Transactional(
      timeout = 300
   )
   public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> completeTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      CoreBpmnRuntimeCompleteProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeCompleteProcessSupport();
      return processSupport.apply(sourceList);
   }

   @Transactional(
      timeout = 300
   )
   public <T extends Auditable<ID>, ID extends Serializable> void transferTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      CoreBpmnRuntimeTransferProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeTransferProcessSupport();
      processSupport.apply(sourceList);
   }

   @Transactional(
      timeout = 300
   )
   public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> endTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      CoreBpmnRuntimeEndProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeEndProcessSupport();
      return processSupport.apply(sourceList);
   }

   @Transactional(
      timeout = 300
   )
   public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> undo(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      CoreBpmnRuntimeUndoProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeUndoProcessSupport();
      return processSupport.apply(sourceList);
   }

   @Transactional(
      timeout = 300
   )
   public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> rejectTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      CoreBpmnRuntimeRejectProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeRejectProcessSupport();
      return processSupport.apply(sourceList);
   }

   @Transactional(
      timeout = 300
   )
   public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> oddRejectTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      CoreBpmnRuntimeOddRejectProcessSupport<T, ID> processSupport = new CoreBpmnRuntimeOddRejectProcessSupport();
      return processSupport.apply(sourceList);
   }

   public <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceNextTaskElementDTO<ID>> getNextTaskList(List<CoreBpmnRuntimeSource<T, ID>> sourceList) {
      List var2;
      try {
         BpmnRuntimeCacheProvider.init(sourceList);
         var2 = BpmnRuntimeCacheProvider.getNextTaskList();
      } finally {
         BpmnRuntimeCacheProvider.remove();
      }

      return var2;
   }

   public <T extends Auditable<ID>, ID extends Serializable> Map<ID, CoreBpmnProcBean> selectRuntimeBpmnProcList(List<T> itemList) {
      if (itemList.isEmpty()) {
         return CollectionUtils.emptyMap();
      } else {
         List<T> rawItemList = new ArrayList();
         List<T> approveItemList = new ArrayList();

         for (T item : itemList) {
            if (StringUtils.startsWithIgnoreCase(item.getProcessStatus(), ProcessStatus.DRAFT.name())) {
               rawItemList.add(item);
            } else if (StringUtils.startsWithIgnoreCase(item.getProcessStatus(), ProcessStatus.APPROVE.name())) {
               approveItemList.add(item);
            }
         }

         Map<ID, CoreBpmnProcBean> runtimeMap = new HashMap();
         if (!rawItemList.isEmpty()) {
            List<CoreBpmnProcBean> procList = this.procService.selectRuntimeBpmnProcList(PersistableMetadataHelper.getTableName(((Auditable)itemList.get(0)).getClass()), LocalContextHelper.getLoginOrgId());
            if (procList.isEmpty()) {
               throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_NOT_EXISTS");
            }

            Iterator var6 = rawItemList.iterator();

            label88:
            while(true) {
               while(true) {
                  if (!var6.hasNext()) {
                     break label88;
                  }

                  T rawItem = (T) var6.next();
                  List<CoreBpmnProcBean> matchProcList = new ArrayList();
                  Iterator var9 = procList.iterator();

                  CoreBpmnProcBean proc;
                  while(var9.hasNext()) {
                     proc = (CoreBpmnProcBean)var9.next();
                     if (StringUtils.isBlank(proc.getExpression())) {
                        matchProcList.add(proc);
                     } else {
                        Map<String, Object> vars = BeanUtils.deeplyToMap(rawItem);
                        if (CoreBpmnHelper.evalExpression(proc.getExpression(), vars)) {
                           if (!matchProcList.isEmpty() && !StringUtils.isBlank(((CoreBpmnProcBean)matchProcList.get(0)).getExpression())) {
                              throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MATCH_MULTIPLE_PROC");
                           }

                           matchProcList.add(0, proc);
                        }
                     }
                  }

                  if (matchProcList.isEmpty()) {
                     throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.ENGINE.PROCESS_NOT_EXISTS");
                  }

                  if (matchProcList.size() == 1) {
                     runtimeMap.put(rawItem.getId(), matchProcList.get(0));
                  } else if (!StringUtils.isBlank(((CoreBpmnProcBean)matchProcList.get(0)).getExpression())) {
                     runtimeMap.put(rawItem.getId(), matchProcList.get(0));
                  } else {
                     var9 = matchProcList.iterator();

                     while(var9.hasNext()) {
                        proc = (CoreBpmnProcBean)var9.next();
                        if (!StringUtils.startsWith(proc.getExt$Item("orgqty"), "0")) {
                           if (runtimeMap.get(rawItem.getId()) != null) {
                              throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MATCH_MULTIPLE_PROC");
                           }

                           runtimeMap.put(rawItem.getId(), proc);
                        }
                     }

                     if (runtimeMap.get(rawItem.getId()) == null) {
                        throw new BpmnException("CORE.MODULE.SYS.T_CORE_BPMN_PROC.DIAGRAM.MATCH_MULTIPLE_PROC");
                     }
                  }
               }
            }
         }

         if (!approveItemList.isEmpty()) {
            String tableName = PersistableMetadataHelper.getTableName(((Auditable)itemList.get(0)).getClass());
            List<String> targetIdList = (List)approveItemList.stream().map((i) -> {
               return tableName + "$" + i.getId();
            }).collect(Collectors.toList());
            List<CoreBpmnInstanceBean> instanceList = this.instanceService.selectListByFilter(SearchFilter.instance().match((String)"TARGETID", targetIdList).filter(MatchPattern.OR), new Order[0]);
            approveItemList.forEach((a) -> {
               CoreBpmnProcBean var10000 = (CoreBpmnProcBean)runtimeMap.put(a.getId(), this.procService.selectById(((CoreBpmnInstanceBean)instanceList.stream().filter((i) -> {
                  return i.getTargetId().equals(tableName + "$" + a.getId());
               }).findAny().get()).getProcId()));
            });
         }

         return runtimeMap;
      }
   }

   public CoreBpmnProcBean getLatestBpmnProc(String procCode) {
      return this.procService.selectLatestProc(procCode);
   }

   public <ID extends Serializable> List<CoreBpmnInstanceTaskBean> selectAuditableInstanceTaskList(String table, ID id, @Nullable String userId) {
      CoreBpmnInstanceBean filter = new CoreBpmnInstanceBean();
      filter.setTargetId(CoreBpmnHelper.getTargetId(table, id));
      CoreBpmnInstanceBean instance = (CoreBpmnInstanceBean)this.instanceService.getDao().selectOneIfPresent(filter);
      return instance == null ? CollectionUtils.emptyList() : this.instanceTaskService.selectAuditableInstanceTaskList(userId, Arrays.asList(instance.getId()));
   }

   @Transactional
   public void processData(BpmnRuntimeData.BpmnProcessData data) {
      List deleteTaskHisList;
      List selectedBpmnTargetList;
      Iterator var6;
      CoreBpmnTargetBean bpmnTarget;
      if (!data.getInsertOrUpdateBpmnTargetList().isEmpty()) {
         deleteTaskHisList = data.getInsertOrUpdateBpmnTargetList().stream().map(CoreBpmnTargetBean::getId).collect(Collectors.toList());
         selectedBpmnTargetList = this.bpmnTargetService.getDao().selectListByIds(deleteTaskHisList);
         List<Persistable> finalSelectedBpmnTargetList = selectedBpmnTargetList;
         List<CoreBpmnTargetBean> insertBpmnTargetList = data.getInsertOrUpdateBpmnTargetList().stream().filter((i) -> finalSelectedBpmnTargetList.stream().noneMatch((s) -> s.getId().equals(i.getId()))).collect(Collectors.toList());
         if (!insertBpmnTargetList.isEmpty()) {
            this.bpmnTargetService.getDao().insert(insertBpmnTargetList);
         }

         List<CoreBpmnTargetBean> updateBpmnTargetList = new ArrayList();
         var6 = selectedBpmnTargetList.iterator();

         label159:
         while(true) {
            do {
               if (!var6.hasNext()) {
                  if (!updateBpmnTargetList.isEmpty()) {
                     this.bpmnTargetService.getDao().update(updateBpmnTargetList, "TARGETDESC", "PROCESSSTATUS");
                  }
                  break label159;
               }

               bpmnTarget = (CoreBpmnTargetBean)var6.next();
               CoreBpmnTargetBean finalBpmnTarget = bpmnTarget;
               bpmnTarget = data.getInsertOrUpdateBpmnTargetList().stream().filter((i) -> {
                  return i.getId().equals(finalBpmnTarget.getId());
               }).findAny().get();
            } while(ObjectUtils.equals(bpmnTarget.getTargetDesc(), bpmnTarget.getTargetDesc()) && ObjectUtils.equals(bpmnTarget.getProcessStatus(), bpmnTarget.getProcessStatus()));

            updateBpmnTargetList.add(bpmnTarget);
         }
      }

      if (!data.getUpdateProcessStatusBpmnTargetList().isEmpty()) {
         deleteTaskHisList = (List)data.getUpdateProcessStatusBpmnTargetList().stream().map(CoreBpmnTargetBean::getId).collect(Collectors.toList());
         selectedBpmnTargetList = this.bpmnTargetService.getDao().selectListByIds(deleteTaskHisList);
         List<CoreBpmnTargetBean> updateBpmnTargetList = new ArrayList();
         Iterator var14 = selectedBpmnTargetList.iterator();

         while(var14.hasNext()) {
            CoreBpmnTargetBean selectedBpmnTarget = (CoreBpmnTargetBean)var14.next();
            bpmnTarget = (CoreBpmnTargetBean)data.getUpdateProcessStatusBpmnTargetList().stream().filter((i) -> {
               return i.getId().equals(selectedBpmnTarget.getId());
            }).findAny().get();
            if (!ObjectUtils.equals(bpmnTarget.getProcessStatus(), selectedBpmnTarget.getProcessStatus())) {
               updateBpmnTargetList.add(bpmnTarget);
            }
         }

         if (!updateBpmnTargetList.isEmpty()) {
            this.bpmnTargetService.getDao().update(data.getUpdateProcessStatusBpmnTargetList(), "PROCESSSTATUS");
         }
      }

      if (!data.getDeleteBpmnTargetIdList().isEmpty()) {
         this.bpmnTargetService.getDao().deleteByIdList(data.getDeleteBpmnTargetIdList());
      }

      if (!data.getInsertInstanceList().isEmpty()) {
         if (!data.getDeleteInstanceList().isEmpty()) {
            data.getInsertInstanceList().removeIf((i) -> {
               return data.getDeleteInstanceList().stream().anyMatch((d) -> {
                  return d.getId().equals(i.getId());
               });
            });
         }

         if (!data.getInsertInstanceList().isEmpty()) {
            this.instanceService.getDao().insert(data.getInsertInstanceList());
         }
      }

      ArrayList taskHisList;
      if (!data.getDeleteInstanceList().isEmpty()) {
         taskHisList = new ArrayList();
         ArrayList finalTaskHisList = taskHisList;
         data.getDeleteInstanceList().forEach((i) -> {
            CoreBpmnInstanceTaskBean taskFilter = new CoreBpmnInstanceTaskBean();
            taskFilter.setInstId(i.getId());
            finalTaskHisList.add(taskFilter);
         });
         data.addDeleteInstanceTaskId(this.instanceTaskService.getDao().selectIdList(taskHisList));
         this.instanceService.getDao().deleteBy(data.getDeleteInstanceList());
      }

      if (!data.getDeleteInstanceTaskIdList().isEmpty() || !data.getDeleteCandidatorInstanceTaskIdList().isEmpty()) {
         taskHisList = new ArrayList();
         List<CoreBpmnInstanceTaskRoleBean> taskRoleFilterList = new ArrayList();
         ArrayList finalTaskHisList1 = taskHisList;
         data.getDeleteInstanceTaskIdList().forEach((i) -> {
            CoreBpmnInstanceTaskUserBean taskUserFilter = new CoreBpmnInstanceTaskUserBean();
            taskUserFilter.setInstTaskId(i);
            finalTaskHisList1.add(taskUserFilter);
            CoreBpmnInstanceTaskRoleBean taskRoleFilter = new CoreBpmnInstanceTaskRoleBean();
            taskRoleFilter.setInstTaskId(i);
            taskRoleFilterList.add(taskRoleFilter);
         });
         ArrayList finalTaskHisList2 = taskHisList;
         data.getDeleteCandidatorInstanceTaskIdList().forEach((i) -> {
            CoreBpmnInstanceTaskUserBean taskUserFilter = new CoreBpmnInstanceTaskUserBean();
            taskUserFilter.setInstTaskId(i);
            finalTaskHisList2.add(taskUserFilter);
            CoreBpmnInstanceTaskRoleBean taskRoleFilter = new CoreBpmnInstanceTaskRoleBean();
            taskRoleFilter.setInstTaskId(i);
            taskRoleFilterList.add(taskRoleFilter);
         });
         data.addDeleteInstanceTaskUserId(this.instanceTaskUserService.getDao().selectIdList((List)taskHisList));
         data.addDeleteInstanceTaskRoleId(this.instanceTaskRoleService.getDao().selectIdList((List)taskRoleFilterList));
         if (!data.getDeleteInstanceTaskIdList().isEmpty()) {
            this.instanceTaskService.getDao().deleteByIdList(data.getDeleteInstanceTaskIdList());
         }
      }

      if (!data.getUpdateInstanceTaskStatusList().isEmpty()) {
         data.getUpdateInstanceTaskStatusList().removeIf((t) -> {
            return data.getDeleteInstanceTaskIdList().contains(t.getId());
         });
         if (!data.getUpdateInstanceTaskStatusList().isEmpty()) {
            this.instanceTaskService.getDao().update(data.getUpdateInstanceTaskStatusList(), "STATUS");
         }
      }

      if (!data.getInsertInstanceTaskList().isEmpty()) {
         data.getInsertInstanceTaskList().removeIf((t) -> {
            return data.getDeleteInstanceTaskIdList().contains(t.getId());
         });
         if (!data.getInsertInstanceTaskList().isEmpty()) {
            this.instanceTaskService.getDao().insert(data.getInsertInstanceTaskList());
         }
      }

      if (!data.getInsertInstanceTaskUserList().isEmpty()) {
         data.getInsertInstanceTaskUserList().removeIf((t) -> {
            return data.getDeleteInstanceTaskUserIdList().contains(t.getId());
         });
         if (!data.getInsertInstanceTaskUserList().isEmpty()) {
            this.instanceTaskUserService.getDao().insert(data.getInsertInstanceTaskUserList());
         }
      }

      if (!data.getInsertInstanceTaskRoleList().isEmpty()) {
         data.getInsertInstanceTaskRoleList().removeIf((t) -> {
            return data.getDeleteInstanceTaskRoleIdList().contains(t.getId());
         });
         if (!data.getInsertInstanceTaskRoleList().isEmpty()) {
            this.instanceTaskRoleService.getDao().insert(data.getInsertInstanceTaskRoleList());
         }
      }

      if (!data.getInsertInstanceTaskList().isEmpty()) {
         taskHisList = new ArrayList();
         Iterator var11 = data.getInsertInstanceTaskList().iterator();

         while(var11.hasNext()) {
            CoreBpmnInstanceTaskBean task = (CoreBpmnInstanceTaskBean)var11.next();
            CoreBpmnInstanceTaskHisCandidatorDTO hisCandidator = new CoreBpmnInstanceTaskHisCandidatorDTO();
            var6 = data.getInsertInstanceTaskUserList().iterator();

            while(var6.hasNext()) {
               CoreBpmnInstanceTaskUserBean taskUser = (CoreBpmnInstanceTaskUserBean)var6.next();
               if (task.getId().equals(taskUser.getInstTaskId())) {
                  hisCandidator.addUserId(taskUser.getUserId());
               }
            }

            var6 = data.getInsertInstanceTaskRoleList().iterator();

            while(var6.hasNext()) {
               CoreBpmnInstanceTaskRoleBean taskRole = (CoreBpmnInstanceTaskRoleBean)var6.next();
               if (task.getId().equals(taskRole.getInstTaskId())) {
                  hisCandidator.addRoleId(taskRole.getRoleId());
               }
            }

            CoreBpmnInstanceTaskHisBean taskHis = new CoreBpmnInstanceTaskHisBean();
            taskHis.setId(ApplicationContextHelper.getNextIdentity());
            taskHis.setInstId(task.getInstId());
            taskHis.setStatusCode(task.getStatusCode());
            taskHis.setCandidatorJson(JSON.toJSONString(hisCandidator));
            taskHisList.add(taskHis);
         }

         this.taskHisService.getDao().insert((List)taskHisList);
      }

      if (!data.getDeleteBpmnTargetIdList().isEmpty()) {
         deleteTaskHisList = (List)data.getDeleteInstanceList().stream().filter((d) -> {
            return data.getDeleteBpmnTargetIdList().contains(d.getTargetId());
         }).map((d) -> {
            CoreBpmnInstanceTaskHisBean taskHis = new CoreBpmnInstanceTaskHisBean();
            taskHis.setInstId(d.getId());
            return taskHis;
         }).collect(Collectors.toList());
         if (!deleteTaskHisList.isEmpty()) {
            List finalDeleteTaskHisList = deleteTaskHisList;
            ExecutorHelper.submit(() -> {
               this.taskHisService.getDao().deleteBy(finalDeleteTaskHisList, "INSTID");
            });
         }
      }

      if (!data.getInsertCommentList().isEmpty()) {
         this.commentService.getDao().insert(data.getInsertCommentList());
      }

      if (!data.getDeleteInstanceTaskUserIdList().isEmpty()) {
         this.instanceTaskUserService.getDao().deleteByIdList(data.getDeleteInstanceTaskUserIdList());
      }

      if (!data.getDeleteInstanceTaskRoleIdList().isEmpty()) {
         this.instanceTaskRoleService.getDao().deleteByIdList(data.getDeleteInstanceTaskRoleIdList());
      }

      if (data.isAsync() && data.getUpdateProcessStatusRunnable() != null) {
         data.getUpdateProcessStatusRunnable().run();
      }

   }
}
