/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine;

import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.module.sys.bpmn.CoreBpmnHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class CoreBpmnRuntimeSource<T extends Auditable<ID>, ID extends Serializable> {
   private String tableName;
   private T oldItem;
   private String comment;
   private Map<String, Object> vars;
   private Long procId;
   private Long attachmentId;
   private Supplier<String> descSupplier;
   private String currentStatusCode;
   private String targetStatusCode;
   private String nextStatusCode;
   private List<String> nextCandidatorList = new ArrayList();
   private List<Long> nextCandidateRoleList = new ArrayList();
   private String runtimeTaskName;
   private boolean runtimeCheckPermission = true;
   private Long runtimeProcId;
   private String runtimeProcessInstanceId;
   private String runtimeInitiator;
   private List<String> candidatorList;
   private String transferCandidator;

   private CoreBpmnRuntimeSource() {
   }

   public static <T extends Auditable<ID>, ID extends Serializable> CoreBpmnRuntimeSource<T, ID> of(String tableName, T oldItem, String comment, Map<String, Object> vars) {
      CoreBpmnRuntimeSource<T, ID> instance = new CoreBpmnRuntimeSource();
      instance.tableName = tableName;
      instance.oldItem = oldItem;
      instance.comment = comment;
      instance.vars = vars;
      return instance;
   }

   public void setProcId(Long procId) {
      this.procId = procId;
   }

   public Long getProcId() {
      return this.procId;
   }

   public String getTableName() {
      return this.tableName;
   }

   public ID getId() {
      return this.getOldItem().getId();
   }

   public T getOldItem() {
      return this.oldItem;
   }

   public void setDescSupplier(Supplier<String> descSupplier) {
      this.descSupplier = descSupplier;
   }

   public String getDesc() {
      return this.descSupplier == null ? ObjectUtils.toString(this.getId()) : (String)this.descSupplier.get();
   }

   public String getComment() {
      return this.comment;
   }

   public void setComment(String comment) {
      this.comment = comment;
   }

   public Map<String, Object> getVars() {
      return this.vars;
   }

   public String getCurrentStatusCode() {
      return this.currentStatusCode;
   }

   public void setCurrentStatusCode(String currentStatusCode) {
      this.currentStatusCode = currentStatusCode;
   }

   public String getTargetStatusCode() {
      return this.targetStatusCode;
   }

   public void setTargetStatusCode(String targetStatusCode) {
      this.targetStatusCode = targetStatusCode;
   }

   public String getNextStatusCode() {
      return this.nextStatusCode;
   }

   public void setNextStatusCode(String nextStatusCode) {
      this.nextStatusCode = nextStatusCode;
   }

   public List<String> getNextCandidatorList() {
      return this.nextCandidatorList;
   }

   public List<Long> getNextCandidateRoleList() {
      return this.nextCandidateRoleList;
   }

   public void addNextCandidator(String candidatorId) {
      this.nextCandidatorList.add(candidatorId);
   }

   public void addNextCandidatorRole(Long candidatorRole) {
      this.nextCandidateRoleList.add(candidatorRole);
   }

   public String getRuntimeTaskName() {
      return this.runtimeTaskName;
   }

   public void setRuntimeTaskName(String runtimeTaskName) {
      this.runtimeTaskName = runtimeTaskName;
   }

   public boolean isRuntimeCheckPermission() {
      return this.runtimeCheckPermission;
   }

   public void setRuntimeCheckPermission(boolean runtimeCheckPermission) {
      this.runtimeCheckPermission = runtimeCheckPermission;
   }

   public String getRuntimeInitiator() {
      return this.runtimeInitiator;
   }

   public void setRuntimeInitiator(String runtimeInitiator) {
      this.runtimeInitiator = runtimeInitiator;
   }

   public Long getRuntimeProcId() {
      return this.runtimeProcId;
   }

   public void setRuntimeProcId(Long runtimeProcId) {
      this.runtimeProcId = runtimeProcId;
   }

   public String getRuntimeProcessInstanceId() {
      return this.runtimeProcessInstanceId;
   }

   public void setRuntimeProcessInstanceId(String runtimeProcessInstanceId) {
      this.runtimeProcessInstanceId = runtimeProcessInstanceId;
   }

   public List<String> getCandidatorList() {
      return this.candidatorList;
   }

   public void setCandidatorList(List<String> candidatorList) {
      this.candidatorList = candidatorList;
   }

   public Long getAttachmentId() {
      return this.attachmentId;
   }

   public void setAttachmentId(Long attachmentId) {
      this.attachmentId = attachmentId;
   }

   public String getTransferCandidator() {
      return this.transferCandidator;
   }

   public void setTransferCandidator(String transferCandidator) {
      this.transferCandidator = transferCandidator;
   }

   public String getTargetId() {
      return CoreBpmnHelper.getTargetId(this.tableName, this.getId());
   }
}
