/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.engine;

import net.sinodawn.framework.support.domain.Auditable;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceNextTaskElementDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceStatusDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnProcBean;
import net.sinodawn.module.sys.bpmn.diagram.ProcessStatus;
import net.sinodawn.module.sys.bpmn.engine.cache.BpmnRuntimeData;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public interface CoreBpmnRuntimeService {
   default <T extends Auditable<ID>, ID extends Serializable> ProcessStatus startProcess(CoreBpmnRuntimeSource<T, ID> source) {
      return ((CoreBpmnInstanceStatusDTO)this.startProcess(Arrays.asList(source)).get(0)).getProcessStatus();
   }

   <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> startProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> withdrawProcess(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> completeTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <T extends Auditable<ID>, ID extends Serializable> void transferTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> endTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> undo(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> rejectTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceStatusDTO<ID>> oddRejectTask(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <ID extends Serializable> List<CoreBpmnInstanceTaskBean> selectAuditableInstanceTaskList(String table, ID id, @Nullable String userId);

   <T extends Auditable<ID>, ID extends Serializable> List<CoreBpmnInstanceNextTaskElementDTO<ID>> getNextTaskList(List<CoreBpmnRuntimeSource<T, ID>> sourceList);

   <T extends Auditable<ID>, ID extends Serializable> Map<ID, CoreBpmnProcBean> selectRuntimeBpmnProcList(List<T> itemList);

   void processData(BpmnRuntimeData.BpmnProcessData data);

   CoreBpmnProcBean getLatestBpmnProc(String procCode);
}
