/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.diagram;

public enum ProcessElementType {
   START_EVENT("startEvent"),
   USER_TASK("userTask"),
   END_EVENT("endEvent"),
   SEQUENCE_FLOW("sequenceFlow"),
   PARALLEL_GATEWAY("parallelGateway"),
   EXCLUSIVE_GATEWAY("exclusiveGateway");

   private String name;

   private ProcessElementType(String name) {
      this.name = name;
   }

   public String getName() {
      return this.name;
   }

   public static ProcessElementType nameOf(String name) {
      ProcessElementType[] var1 = values();
      int var2 = var1.length;

      for(int var3 = 0; var3 < var2; ++var3) {
         ProcessElementType type = var1[var3];
         if (type.getName().equals(name)) {
            return type;
         }
      }

      return null;
   }
}
