/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.dao.impl;

import net.sinodawn.framework.data.ListChunkIterator;
import net.sinodawn.framework.mybatis.dao.MybatisDaoSupport;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskHisBean;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnInstanceTaskHisDao;
import net.sinodawn.module.sys.bpmn.mapper.CoreBpmnInstanceTaskHisMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Repository
public class CoreBpmnInstanceTaskHisDaoImpl extends MybatisDaoSupport<CoreBpmnInstanceTaskHisBean, Long> implements CoreBpmnInstanceTaskHisDao {
   @Autowired
   private CoreBpmnInstanceTaskHisMapper instanceTaskHisMapper;

   public CoreBpmnInstanceTaskHisMapper getMapper() {
      return this.instanceTaskHisMapper;
   }

   public List<CoreBpmnInstanceTaskHisBean> selectLatestTaskHisList(List<CoreBpmnInstanceTaskHisBean> filterList) {
      List<Map<String, Object>> mapList = new ArrayList();
      int loopItemQty = Math.min(filterList.size(), 1000);
      ListChunkIterator chunkIterator = ListChunkIterator.of(filterList, loopItemQty);

      while(chunkIterator.hasNext()) {
         mapList.addAll(this.getMapper().selectLatestTaskHisList(chunkIterator.nextChunk()));
      }

      return CollectionUtils.isEmpty((Collection)mapList) ? CollectionUtils.emptyList() : (List)mapList.stream().map((m) -> {
         return (CoreBpmnInstanceTaskHisBean)PersistableHelper.mapToPersistable(m, CoreBpmnInstanceTaskHisBean.class);
      }).collect(Collectors.toList());
   }
}
