/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.dao.impl;

import net.sinodawn.framework.data.ListChunkIterator;
import net.sinodawn.framework.database.dialect.Dialect;
import net.sinodawn.framework.mybatis.dao.MybatisDaoSupport;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskBean;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnInstanceTaskDao;
import net.sinodawn.module.sys.bpmn.mapper.CoreBpmnInstanceTaskMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Repository
public class CoreBpmnInstanceTaskDaoImpl extends MybatisDaoSupport<CoreBpmnInstanceTaskBean, Long> implements CoreBpmnInstanceTaskDao {
   @Autowired
   private CoreBpmnInstanceTaskMapper instanceTaskMapper;
   @Autowired
   private Dialect dialect;

   public CoreBpmnInstanceTaskMapper getMapper() {
      return this.instanceTaskMapper;
   }

   public List<CoreBpmnInstanceTaskBean> selectAuditableInstanceTaskList(@Nullable String userId, List<Long> instIdList) {
      int chunkSize = this.dialect.getMaxParamQty();
      List<CoreBpmnInstanceTaskBean> resultList = new ArrayList();
      ListChunkIterator chunkIterator = ListChunkIterator.of(instIdList, chunkSize);

      while(chunkIterator.hasNext()) {
         resultList.addAll((Collection)this.getMapper().selectAuditableInstanceTaskList(userId, chunkIterator.nextChunk()).stream().map((m) -> {
            return (CoreBpmnInstanceTaskBean)PersistableHelper.mapToPersistable((Map<String, Object>) m, CoreBpmnInstanceTaskBean.class);
         }).collect(Collectors.toList()));
      }

      return resultList;
   }
}
