/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.dao.impl;

import net.sinodawn.framework.mybatis.dao.MybatisDaoSupport;
import net.sinodawn.framework.support.PersistableHelper;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceBean;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceCandidatorDTO;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnInstanceTaskCandidatorDTO;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnInstanceDao;
import net.sinodawn.module.sys.bpmn.mapper.CoreBpmnInstanceMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.stream.Collectors;

@Repository
public class CoreBpmnInstanceDaoImpl extends MybatisDaoSupport<CoreBpmnInstanceBean, Long> implements CoreBpmnInstanceDao {
   @Autowired
   private CoreBpmnInstanceMapper instanceMapper;

   public CoreBpmnInstanceMapper getMapper() {
      return this.instanceMapper;
   }

   public List<CoreBpmnInstanceCandidatorDTO> selectInstanceCandidatorList(List<Long> idList) {
      return (List)this.getMapper().selectInstanceAuditorList(idList).stream().map((m) -> {
         return (CoreBpmnInstanceCandidatorDTO)PersistableHelper.mapToPersistable(m, CoreBpmnInstanceCandidatorDTO.class);
      }).collect(Collectors.toList());
   }

   public List<CoreBpmnInstanceTaskCandidatorDTO> selectInstanceTaskAuditorList(List<Long> idList) {
      return (List)this.getMapper().selectInstanceTaskAuditorList(idList).stream().map((m) -> {
         return (CoreBpmnInstanceTaskCandidatorDTO)PersistableHelper.mapToPersistable(m, CoreBpmnInstanceTaskCandidatorDTO.class);
      }).collect(Collectors.toList());
   }
}
