/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.dao.impl;

import net.sinodawn.framework.mybatis.dao.MybatisDaoSupport;
import net.sinodawn.module.sys.bpmn.bean.CoreBpmnDiagramBean;
import net.sinodawn.module.sys.bpmn.dao.CoreBpmnDiagramDao;
import net.sinodawn.module.sys.bpmn.mapper.CoreBpmnDiagramMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

@Repository
public class CoreBpmnDiagramDaoImpl extends MybatisDaoSupport<CoreBpmnDiagramBean, Long> implements CoreBpmnDiagramDao {
   @Autowired
   private CoreBpmnDiagramMapper diagramMapper;

   public CoreBpmnDiagramMapper getMapper() {
      return this.diagramMapper;
   }

   @Cacheable(
      value = {"T_CORE_BPMN_DIAGRAM"},
      key = "'' + #id",
      unless = "#result == null"
   )
   public CoreBpmnDiagramBean selectByIdIfPresent(Long id) {
      return (CoreBpmnDiagramBean)super.selectByIdIfPresent(id);
   }

   @CacheEvict(
      value = {"T_CORE_BPMN_DIAGRAM", "T_CORE_BPMN_DIAGRAM.DOCUMENT", "T_CORE_BPMN_DIAGRAM.TASKCANDIDATOR", "T_CORE_BPMN_DIAGRAM.SEQUENCEFLOWCONDITION"},
      keyGenerator = "defaultDaoCacheEvictKeyGenerator"
   )
   public void cacheEvict(CoreBpmnDiagramBean oldItem, CoreBpmnDiagramBean newItem) {
   }
}
