/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.bean;

import net.sinodawn.framework.support.domain.AbstractBaseData;
import net.sinodawn.framework.support.domain.BaseData;
import net.sinodawn.framework.utils.ObjectUtils;

public class CoreBpmnRejectableTaskDTO extends AbstractBaseData implements BaseData {
   private static final long serialVersionUID = -527699645477065148L;
   private String taskName;
   private String statusCode;

   public String getTaskName() {
      return this.taskName;
   }

   public void setTaskName(String taskName) {
      this.taskName = taskName;
   }

   public String getStatusCode() {
      return this.statusCode;
   }

   public void setStatusCode(String statusCode) {
      this.statusCode = statusCode;
   }

   public boolean equals(Object target) {
      if (target == null) {
         return false;
      } else if (target == this) {
         return true;
      } else if (!(target instanceof CoreBpmnRejectableTaskDTO)) {
         return false;
      } else {
         CoreBpmnRejectableTaskDTO task = (CoreBpmnRejectableTaskDTO)target;
         return ObjectUtils.equals(this.getTaskName(), task.getTaskName()) && ObjectUtils.equals(this.getStatusCode(), task.getStatusCode());
      }
   }
}
