/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn.bean;

import net.sinodawn.framework.data.annotation.Clob;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import org.springframework.data.annotation.Id;
import org.springframework.lang.Nullable;

@Table("T_CORE_BPMN_COMMENT")
public class CoreBpmnCommentBean extends AbstractInsertable<Long> implements Insertable<Long> {
   private static final long serialVersionUID = 8731362359855549210L;
   @Id
   private Long id;
   private Long procId;
   private String targetId;
   private String taskId;
   private String taskName;
   private String statusCode;
   private String userId;
   private Long roleId;
   @Nullable
   private Long attachmentId;
   private String status;
   private String route;
   @Clob
   private String comment;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public Long getProcId() {
      return this.procId;
   }

   public void setProcId(Long procId) {
      this.procId = procId;
   }

   public String getTaskId() {
      return this.taskId;
   }

   public void setTaskId(String taskId) {
      this.taskId = taskId;
   }

   public String getTaskName() {
      return this.taskName;
   }

   public void setTaskName(String taskName) {
      this.taskName = taskName;
   }

   public String getStatusCode() {
      return this.statusCode;
   }

   public void setStatusCode(String statusCode) {
      this.statusCode = statusCode;
   }

   public String getTargetId() {
      return this.targetId;
   }

   public void setTargetId(String targetId) {
      this.targetId = targetId;
   }

   public String getUserId() {
      return this.userId;
   }

   public void setUserId(String userId) {
      this.userId = userId;
   }

   public Long getRoleId() {
      return this.roleId;
   }

   public void setRoleId(Long roleId) {
      this.roleId = roleId;
   }

   public String getComment() {
      return this.comment;
   }

   public void setComment(String comment) {
      this.comment = comment;
   }

   public String getStatus() {
      return this.status;
   }

   public void setStatus(String status) {
      this.status = status;
   }

   public Long getAttachmentId() {
      return this.attachmentId;
   }

   public void setAttachmentId(Long attachmentId) {
      this.attachmentId = attachmentId;
   }

   public String getRoute() {
      return this.route;
   }

   public void setRoute(String route) {
      this.route = route;
   }
}
