/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.bpmn;

//import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.utils.CollectionUtils;
import net.sinodawn.framework.utils.ObjectUtils;
import net.sinodawn.framework.utils.ScriptUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.bpmn.diagram.BpmnDiagramHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Element;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CoreBpmnHelper {
   private static final Logger logger = LogManager.getLogger(CoreBpmnHelper.class);

   public static final <ID> String getTargetId(String table, ID id) {
      return table + "$" + ObjectUtils.toString(id);
   }

   public static final String getCorrectedDiagram(String diagram) {
      return StringUtils.replace(diagram, "camunda:=\"\"", "");
   }

   public static boolean evalSequenceFlowConditionExpression(Element sequenceFlowElement, Map<String, Object> vars) {
      String expression = BpmnDiagramHelper.getConditionExpression(sequenceFlowElement);
      return evalExpression(expression, vars);
   }

   public static boolean evalExpression(String expression, Map<String, Object> vars) {
      if (StringUtils.isEmpty(expression)) {
         return true;
      } else {
         String copyExpression = expression;
         List<String> substringList = StringUtils.substringsBetween(expression, "${", "}");
         Iterator var4 = substringList.iterator();

         while(true) {
            while(var4.hasNext()) {
               String substring = (String)var4.next();
               if (!CollectionUtils.containsKeyIgnorecase(vars, substring)) {
//                  throw new BpmnException(I18nHelper.getMessage("SINO.BPMN.TIP.EXPRESSION_MISSING_PARAMETER", expression, substring));
               }

               Object value = CollectionUtils.getValueIgnorecase(vars, substring);
               if (value != null && Number.class.isAssignableFrom(value.getClass())) {
                  copyExpression = StringUtils.replace(copyExpression, "${" + substring + "}", ObjectUtils.toString(value));
               } else {
                  copyExpression = StringUtils.replace(copyExpression, "${" + substring + "}", "'" + ObjectUtils.toString(value) + "'");
               }
            }

            try {
               return (Boolean)ScriptUtils.evalJavaScript(copyExpression);
            } catch (Exception var7) {
               logger.error(var7);
//               throw new BpmnException(I18nHelper.getMessage("SINO.BPMN.TIP.EVAL_EXPRESSION_ERROR", expression, copyExpression));
            }
         }
      }
   }
}
