/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.service.impl;

import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordDTO;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import net.sinodawn.module.sys.at.dao.CoreAuditTrailRecordDao;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordLineService;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

@Repository
public class CoreAuditTrailRecordServiceImpl implements CoreAuditTrailRecordService {
   @Autowired
   private CoreAuditTrailRecordDao recordDao;
   @Autowired
   private CoreAuditTrailRecordLineService recordLineService;

   public CoreAuditTrailRecordDao getDao() {
      return this.recordDao;
   }

   @Transactional
   @AuditTrailEntry(AuditTrailType.INSERT)
   @Audit("AUDIT.INSERT")
   public Long insert(CoreAuditTrailRecordBean record) {
      record.setId(ApplicationContextHelper.getNextIdentity());
      this.getDao().insert(record);
      return record.getId();
   }

   public List<CoreAuditTrailRecordDTO> selectRecordList(String tableName, String id) {
      SearchFilter recordLineFilter = SearchFilter.instance().match((String)"TARGETID", tableName + "$" + id).filter(MatchPattern.EQ);
      List<CoreAuditTrailRecordLineBean> recordLineList = this.recordLineService.selectListByFilter(recordLineFilter, new Order[0]);
      List<Long> recordIdList = recordLineList.stream().map(CoreAuditTrailRecordLineBean::getRecordId).distinct().collect(Collectors.toList());
      List<CoreAuditTrailRecordBean> recordList = this.getDao().selectListByIds(recordIdList, new Order[]{Order.desc("ID")});
      return recordList.stream().map((r) -> new CoreAuditTrailRecordDTO(r, recordLineList.stream().filter((l) -> l.getRecordId().equals(r.getId())).sorted(Comparator.comparing(CoreAuditTrailRecordLineBean::getId)).collect(Collectors.toList()))).collect(Collectors.toList());
   }

   public List<CoreAuditTrailRecordBean> selectAtRecordList(String tableName, String id) {
      String targetId = tableName + "$" + id;
      List<CoreAuditTrailRecordBean> recordList = this.getDao().selectListByOneColumnValue(targetId, "TARGETID", new Order[]{Order.desc("ID")});
      return recordList.isEmpty() ? null : recordList;
   }

   public List<CoreAuditTrailRecordBean> selectAtRecordList(String tableName, RestJsonWrapperBean wrapper) {
      String recordId = wrapper.getFilterValue("recordId");
      SearchFilter recordFilter = SearchFilter.instance();
      if (StringUtils.isEmpty(recordId)) {
         recordFilter = recordFilter.match((String)"TARGETID", tableName + "$").filter(MatchPattern.SB);
      } else {
         recordFilter = recordFilter.match((String)"TARGETID", tableName + "$" + recordId).filter(MatchPattern.EQ);
      }

      List<CoreAuditTrailRecordBean> recordList = this.selectListByFilter(recordFilter, wrapper);
      return recordList.isEmpty() ? null : recordList;
   }

   public List<CoreAuditTrailRecordLineBean> selectRecordLineTableNameList(Long recordId) {
      return this.recordLineService.selectRecordLineTableNameList(recordId);
   }

   public List<CoreAuditTrailRecordLineBean> selectRecordLineList(Long recordId, String tableName) {
      return this.recordLineService.selectRecordLineList(recordId, tableName);
   }

   public Page<CoreAuditTrailRecordLineBean> selectRecordLinePaginationList(RestJsonWrapperBean wrapper) {
      return this.recordLineService.selectPagination(wrapper);
   }

   public CoreAuditTrailRecordLineBean selectRecordLineDetail(Long id) {
      return (CoreAuditTrailRecordLineBean)this.recordLineService.selectByIdIfPresent(id);
   }
}
