/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.service.impl;

import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import net.sinodawn.module.sys.at.dao.CoreAuditTrailRecordLineDao;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordLineService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
@Repository
public class CoreAuditTrailRecordLineServiceImpl implements CoreAuditTrailRecordLineService {
   @Autowired
   private CoreAuditTrailRecordLineDao recordLineDao;

   public CoreAuditTrailRecordLineDao getDao() {
      return this.recordLineDao;
   }

   @Transactional
   @AuditTrailEntry(AuditTrailType.INSERT)
   @Audit("AUDIT.INSERT")
   public void insert(List<CoreAuditTrailRecordLineBean> lineList) {
      int qty = lineList.size();
      List<Long> idList = ApplicationContextHelper.getNextIdentityList(qty);

      for(int i = 0; i < qty; ++i) {
         ((CoreAuditTrailRecordLineBean)lineList.get(i)).setId((Long)idList.get(i));
      }

      this.getDao().insert(lineList);
   }

   public List<CoreAuditTrailRecordLineBean> selectRecordLineTableNameList(Long recordId) {
      List<String> tableNameList = this.getDao().selectTableNameByRecordId(recordId + "");
      if (tableNameList.isEmpty()) {
         return null;
      } else {
         List<CoreAuditTrailRecordLineBean> recordLineList = new ArrayList();
         tableNameList.forEach((e) -> {
            CoreAuditTrailRecordLineBean recordLine = new CoreAuditTrailRecordLineBean();
            recordLine.setTableName(e);
            recordLine.setRecordId(NumberUtils.parseLong(recordId));
            recordLineList.add(recordLine);
         });
         return recordLineList;
      }
   }

   public List<CoreAuditTrailRecordLineBean> selectRecordLineList(Long recordId, String tableName) {
      CoreAuditTrailRecordLineBean recordLine = new CoreAuditTrailRecordLineBean();
      recordLine.setRecordId(recordId);
      recordLine.setTableName(tableName);
      List<CoreAuditTrailRecordLineBean> lineList = this.getDao().selectList(recordLine, new Order[]{Order.asc("TARGETID")});
      return lineList.isEmpty() ? null : lineList;
   }
}
