/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordDTO;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

public interface CoreAuditTrailRecordService extends GenericService<CoreAuditTrailRecordBean, Long> {
   Long insert(CoreAuditTrailRecordBean record);

   List<CoreAuditTrailRecordDTO> selectRecordList(String tableName, String id);

   List<CoreAuditTrailRecordBean> selectAtRecordList(String tableName, String id);

   List<CoreAuditTrailRecordLineBean> selectRecordLineTableNameList(@PathVariable Long recordId);

   List<CoreAuditTrailRecordLineBean> selectRecordLineList(@PathVariable Long recordId, @PathVariable String tableName);

   Page<CoreAuditTrailRecordLineBean> selectRecordLinePaginationList(RestJsonWrapperBean wrapper);

   CoreAuditTrailRecordLineBean selectRecordLineDetail(@PathVariable Long id);

   List<CoreAuditTrailRecordBean> selectAtRecordList(String tableName, RestJsonWrapperBean wrapper);
}
