/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigLineBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigTreeDTO;
import java.util.List;

public interface CoreAuditTrailConfigService extends GenericService<CoreAuditTrailConfigBean, String> {
   void insert(String table);

   Page<CoreAuditTrailConfigTreeDTO> selectAuditTrailableTreePagination(RestJsonWrapperBean wrapper);

   Page<CoreAuditTrailConfigLineBean> selectAuditTrailConfigLineListByConfig(String id, RestJsonWrapperBean wrapper);

   void auditConfigLines(String id, RestJsonWrapperBean wrapper);

   void cancelConfigLines(String id, RestJsonWrapperBean wrapper);

   List<CoreAuditTrailConfigLineBean> selectAuditTrailableLineList(String table);

   void revisingAuditTrailConfigLine(String id);

   boolean auditTrailable(String table);
}
