/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordDTO;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import net.sinodawn.module.sys.at.resource.CoreAuditTrailRecordResource;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordLineService;
import net.sinodawn.module.sys.at.service.CoreAuditTrailRecordService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
@RestController
public class CoreAuditTrailRecordResourceImpl implements CoreAuditTrailRecordResource {
   @Autowired
   private CoreAuditTrailRecordService recordService;
   @Autowired
   private CoreAuditTrailRecordLineService recordLineService;

   public CoreAuditTrailRecordService getService() {
      return this.recordService;
   }

   public CoreAuditTrailRecordLineService getLineService() {
      return this.recordLineService;
   }

   @Log(
      value = "审计跟踪记录查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/queries/searchable/{tableName}/{id}"},
      method = {RequestMethod.POST}
   )
   public List<CoreAuditTrailRecordDTO> selectRecordList(@PathVariable String tableName, @PathVariable String id) {
      return this.getService().selectRecordList(tableName, id);
   }

   @Log(
      value = "审计跟踪记录查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/queries/atrecord/{tableName}/{id}"},
      method = {RequestMethod.POST}
   )
   public List<CoreAuditTrailRecordBean> selectAtRecordList(@PathVariable String tableName, @PathVariable String id) {
      return this.getService().selectAtRecordList(tableName, id);
   }

   @Log(
      value = "根据表名查询审计跟踪记录",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/queries/atrecord/{tableName}"},
      method = {RequestMethod.POST}
   )
   public List<CoreAuditTrailRecordBean> selectAtRecordList(@PathVariable String tableName, RestJsonWrapperBean wrapper) {
      return this.getService().selectAtRecordList(tableName, wrapper);
   }

   @Log(
      value = "审计跟踪查询相关表",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/queries/record-lines/{recordId}"},
      method = {RequestMethod.POST}
   )
   public List<CoreAuditTrailRecordLineBean> selectRecordLineTableNameList(@PathVariable Long recordId) {
      return this.getService().selectRecordLineTableNameList(recordId);
   }

   @Log(
      value = "审计跟踪查询相关表字段修改",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/queries/record-lines/{recordId}/{tableName}"},
      method = {RequestMethod.POST}
   )
   public List<CoreAuditTrailRecordLineBean> selectRecordLineList(@PathVariable Long recordId, @PathVariable String tableName) {
      return this.getService().selectRecordLineList(recordId, tableName);
   }

   @Log(
      value = "审计跟踪明细表详情查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/record-lines/{recordLineId}"},
      method = {RequestMethod.GET}
   )
   public CoreAuditTrailRecordLineBean selectRecordLineDetail(@PathVariable Long recordLineId) {
      return this.getService().selectRecordLineDetail(recordLineId);
   }

   @Log(
      value = "审计跟踪明细表查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/record-lines/queries"},
      method = {RequestMethod.POST}
   )
   public Page<CoreAuditTrailRecordLineBean> selectRecordLinePaginationList(RestJsonWrapperBean wrapper) {
      return this.getService().selectRecordLinePaginationList(wrapper);
   }
}
