/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigLineBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigTreeDTO;
import net.sinodawn.module.sys.at.resource.CoreAuditTrailConfigResource;
import net.sinodawn.module.sys.at.service.CoreAuditTrailConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CoreAuditTrailConfigResourceImpl implements CoreAuditTrailConfigResource {
   @Autowired
   private CoreAuditTrailConfigService configService;

   public CoreAuditTrailConfigService getService() {
      return this.configService;
   }

   @Log(
      value = "可审计跟踪的配置查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/audit-trailable/tree-grid"},
      method = {RequestMethod.POST}
   )
   public Page<CoreAuditTrailConfigTreeDTO> selectAuditTrailableTreePagination(RestJsonWrapperBean wrapper) {
      return this.getService().selectAuditTrailableTreePagination(wrapper);
   }

   @Log(
      value = "审计跟踪的配置明细查询",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/{id}/at-config-lines"},
      method = {RequestMethod.POST}
   )
   public Page<CoreAuditTrailConfigLineBean> selectAuditTrailConfigLineListByConfig(@PathVariable String id, RestJsonWrapperBean wrapper) {
      return this.getService().selectAuditTrailConfigLineListByConfig(id, wrapper);
   }

   @Log(
      value = "审计",
      type = LogType.UPDATE
   )
   @RequestMapping(
      value = {"/{id}/at-config-lines/action/audit"},
      method = {RequestMethod.PUT}
   )
   public void audit(@PathVariable String id, RestJsonWrapperBean wrapper) {
      this.getService().auditConfigLines(id, wrapper);
   }

   @Log(
      value = "取消审计",
      type = LogType.UPDATE
   )
   @RequestMapping(
      value = {"/{id}/at-config-lines/action/cancel"},
      method = {RequestMethod.PUT}
   )
   public void cancel(@PathVariable String id, RestJsonWrapperBean wrapper) {
      this.getService().cancelConfigLines(id, wrapper);
   }
}
