/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordDTO;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailRecordLineBean;
import java.util.List;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping({"/secure/core/module/sys/at-records"})
public interface CoreAuditTrailRecordResource {
   List<CoreAuditTrailRecordDTO> selectRecordList(@PathVariable String tableName, @PathVariable String id);

   List<CoreAuditTrailRecordBean> selectAtRecordList(@PathVariable String tableName, @PathVariable String id);

   List<CoreAuditTrailRecordLineBean> selectRecordLineTableNameList(@PathVariable Long recordId);

   List<CoreAuditTrailRecordLineBean> selectRecordLineList(@PathVariable Long recordId, @PathVariable String tableName);

   Page<CoreAuditTrailRecordLineBean> selectRecordLinePaginationList(RestJsonWrapperBean wrapper);

   CoreAuditTrailRecordLineBean selectRecordLineDetail(@PathVariable Long id);

   List<CoreAuditTrailRecordBean> selectAtRecordList(@PathVariable String tableName, RestJsonWrapperBean wrapper);
}
