/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigLineBean;
import net.sinodawn.module.sys.at.bean.CoreAuditTrailConfigTreeDTO;
import net.sinodawn.module.sys.at.service.CoreAuditTrailConfigService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping({"/secure/core/module/sys/at-configs"})
public interface CoreAuditTrailConfigResource extends GenericResource<CoreAuditTrailConfigService, CoreAuditTrailConfigBean, String> {
   Page<CoreAuditTrailConfigTreeDTO> selectAuditTrailableTreePagination(RestJsonWrapperBean wrapper);

   Page<CoreAuditTrailConfigLineBean> selectAuditTrailConfigLineListByConfig(@PathVariable String id, RestJsonWrapperBean wrapper);

   void audit(@PathVariable String id, RestJsonWrapperBean wrapper);

   void cancel(@PathVariable String id, RestJsonWrapperBean wrapper);
}
