/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.bean;

import com.alibaba.fastjson.annotation.JSONField;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Table("T_CORE_AT_RECORD_LINE")
public class CoreAuditTrailRecordLineBean extends AbstractInsertable<Long> implements Insertable<Long> {
   @Transient
   private static final long serialVersionUID = 1073086729372841388L;
   @Id
   private Long id;
   private Long recordId;
   private String tableName;
   private String targetId;
   private String recordType;
   private String column;
   private String oldValue;
   private String newValue;
   @JSONField(
      format = "yyyy-MM-dd HH:mm:ss"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime createdTime;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public Long getRecordId() {
      return this.recordId;
   }

   public void setRecordId(Long recordId) {
      this.recordId = recordId;
   }

   public String getTargetId() {
      return this.targetId;
   }

   public void setTargetId(String targetId) {
      this.targetId = targetId;
   }

   public String getRecordType() {
      return this.recordType;
   }

   public void setRecordType(String recordType) {
      this.recordType = recordType;
   }

   public String getTableName() {
      return this.tableName;
   }

   public void setTableName(String tableName) {
      this.tableName = tableName;
   }

   public String getColumn() {
      return this.column;
   }

   public void setColumn(String column) {
      this.column = column;
   }

   public String getOldValue() {
      return this.oldValue;
   }

   public void setOldValue(String oldValue) {
      this.oldValue = oldValue;
   }

   public String getNewValue() {
      return this.newValue;
   }

   public void setNewValue(String newValue) {
      this.newValue = newValue;
   }
}
