/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.bean;

import org.springframework.data.annotation.Transient;
import net.sinodawn.framework.utils.ObjectUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CoreAuditTrailRecordDTO implements Serializable {
   @Transient
   private static final long serialVersionUID = -7671022420713135166L;
   private CoreAuditTrailRecordBean auditTrailRecord;
   private List<CoreAuditTrailRecordLineBean> auditTrailRecordLineList;

   public CoreAuditTrailRecordDTO(CoreAuditTrailRecordBean auditTrailRecord, List<CoreAuditTrailRecordLineBean> auditTrailRecordLineList) {
      this.auditTrailRecord = auditTrailRecord;
      this.auditTrailRecordLineList = (List)ObjectUtils.defaultIfNull(auditTrailRecordLineList, new ArrayList());
   }

   public CoreAuditTrailRecordBean getAuditTrailRecord() {
      return this.auditTrailRecord;
   }

   public List<CoreAuditTrailRecordLineBean> getAuditTrailRecordLineList() {
      return this.auditTrailRecordLineList;
   }
}
