/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.bean;

import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;

@Table("T_CORE_AT_CONFIG_LINE")
public class CoreAuditTrailConfigLineBean extends AbstractInsertable<Long> implements Insertable<Long> {
   @Transient
   private static final long serialVersionUID = 3883646851421317773L;
   @Id
   private Long id;
   private String configId;
   private String columnId;
   @NotNull(
      defaultValue = "0"
   )
   private String auditTrail;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public String getConfigId() {
      return this.configId;
   }

   public void setConfigId(String configId) {
      this.configId = configId;
   }

   public String getColumnId() {
      return this.columnId;
   }

   public void setColumnId(String columnId) {
      this.columnId = columnId;
   }

   public String getAuditTrail() {
      return this.auditTrail;
   }

   public void setAuditTrail(String auditTrail) {
      this.auditTrail = auditTrail;
   }
}
