/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.at.bean;

import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;

@Table("T_CORE_AT_CONFIG")
public class CoreAuditTrailConfigBean extends AbstractInsertable<String> implements Insertable<String> {
   @Transient
   private static final long serialVersionUID = -3865212091332287663L;
   @Id
   private String id;
   @NotNull(
      defaultValue = "1"
   )
   private String auditTrail;

   public String getId() {
      return this.id;
   }

   public void setId(String id) {
      this.id = id;
   }

   public String getAuditTrail() {
      return this.auditTrail;
   }

   public void setAuditTrail(String auditTrail) {
      this.auditTrail = auditTrail;
   }
}
