/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.addomain.resource.impl;

import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.data.RestValidationResultBean;
import net.sinodawn.module.sys.addomain.resource.CoreAdDomainResource;
import net.sinodawn.module.sys.addomain.service.CoreAdDomainUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CoreAdDomainResourceImpl implements CoreAdDomainResource {
   @Autowired
   private CoreAdDomainUserService coreAdDomainUserService;

   @Log(
      value = "新增或修改AD域用户",
      type = LogType.INSERT
   )
   public void insertAdDomainUser(RestJsonWrapperBean wrapper) {
      this.coreAdDomainUserService.insert(wrapper);
   }

   @Log(
      value = "校验AD域用户",
      type = LogType.VALIDATE
   )
   public RestValidationResultBean validateAdDomainUserUnique(String id, String columnName, String columnValue) {
      return this.coreAdDomainUserService.validateUnique(id, columnName, columnValue);
   }
}
