/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.sys.addomain.resource;

import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.restful.data.RestValidationResultBean;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping({"/secure/core/module/sys/ad-domains"})
public interface CoreAdDomainResource {
   @RequestMapping(
      value = {"/ad-domain-users"},
      method = {RequestMethod.POST}
   )
   void insertAdDomainUser(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/ad-domain-users/{id}/action/validate-unique", "/ad-domain-users/{id}/action/validate-unique/{columnName}/{columnValue}", "/ad-domain-users/action/validate-unique/{columnName}/{columnValue}"},
      method = {RequestMethod.POST}
   )
   RestValidationResultBean validateAdDomainUserUnique(@PathVariable(required = false) String id, @PathVariable(required = false) String columnName, @PathVariable(required = false) String columnValue);
}
