/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.user.service;

import net.sinodawn.framework.restful.data.RestHttpTextEntity;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.bean.CoreUserSignatureDTO;

public interface CoreUserService extends GenericService<CoreUserBean, String> {
   String insert(RestJsonWrapperBean wrapper);

   void delete(String id);

   CoreUserBean selectByLoginId(String loginId);

   void resetPassword(RestJsonWrapperBean wrapper);

   void resetPassword(String id);

   RestHttpTextEntity changePassword(RestJsonWrapperBean wrapper);

   RestHttpTextEntity changePassword(String id, RestJsonWrapperBean wrapper);

   RestHttpTextEntity changeNewPassword(RestJsonWrapperBean wrapper);

   void deprecate(RestJsonWrapperBean wrapper);

   void insertUserPermission(String id, String permissionTypeId, RestJsonWrapperBean wrapper);

   void deleteUserPermission(String id, String permissionTypeId, RestJsonWrapperBean wrapper);

   void setDefaultUserPermission(String id, String permissionTypeId, RestJsonWrapperBean wrapper);

   CoreUserSignatureDTO sign(RestJsonWrapperBean wrapper);

   String selectSignatureUrl(String userId);

   boolean defaultPassword();

   String selectAvatarUrl(String userId);
}
