/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.user.resource.impl;

import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestHttpTextEntity;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.bean.CoreUserSignatureDTO;
import net.sinodawn.module.mdm.user.resource.CoreUserResource;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.Objects;

@LogModule("系统用户")
@RestController
public class CoreUserResourceImpl implements CoreUserResource {
   @Autowired
   private CoreUserService userService;

   public CoreUserService getService() {
      return this.userService;
   }

   @Log(
      value = "新增用户",
      type = LogType.INSERT
   )
   public String insert(RestJsonWrapperBean wrapper) {
      return this.getService().insert(wrapper);
   }

   @Log(
      value = "查询用户信息",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/current-user", "/{id}"},
      method = {RequestMethod.GET}
   )
   public CoreUserBean selectDetail(@PathVariable(required = false) String id) {
      return (CoreUserBean)CoreUserResource.super.selectDetail(Objects.toString(id, LocalContextHelper.getLoginUserId()));
   }

   @Log(
      value = "修改登录用户密码",
      type = LogType.UPDATE
   )
   public RestHttpTextEntity changePassword(RestJsonWrapperBean wrapper) {
      return this.getService().changePassword(wrapper);
   }

   public RestHttpTextEntity changeNewPassword(RestJsonWrapperBean wrapper) {
      return this.getService().changeNewPassword(wrapper);
   }

   @Log(
      value = "修改用户密码",
      type = LogType.UPDATE
   )
   public RestHttpTextEntity changePassword(@PathVariable String id, RestJsonWrapperBean wrapper) {
      return this.getService().changePassword(id, wrapper);
   }

   @Log(
      value = "重置系统用户的登录密码",
      type = LogType.UPDATE
   )
   public void resetPassword(RestJsonWrapperBean wrapper) {
      this.userService.resetPassword(wrapper);
   }

   @Log(
      value = "废弃",
      type = LogType.UPDATE
   )
   public void deprecate(RestJsonWrapperBean wrapper) {
      this.getService().deprecate(wrapper);
   }

   @Log(
      value = "指定用户下新增指定类型的权限",
      type = LogType.INSERT
   )
   @RequestMapping(
      value = {"/{id}/user-permission-types/{permissionTypeId}/user-permissions"},
      method = {RequestMethod.POST}
   )
   public void insertUserPermission(@PathVariable String id, @PathVariable String permissionTypeId, RestJsonWrapperBean wrapper) {
      this.getService().insertUserPermission(id, permissionTypeId, wrapper);
   }

   @Log(
      value = "指定用户下删除指定类型下的权限",
      type = LogType.DELETE
   )
   @RequestMapping(
      value = {"/{id}/user-permission-types/{permissionTypeId}/user-permissions"},
      method = {RequestMethod.DELETE}
   )
   public void deleteUserPermission(@PathVariable String id, @PathVariable String permissionTypeId, RestJsonWrapperBean wrapper) {
      this.getService().deleteUserPermission(id, permissionTypeId, wrapper);
   }

   @Log(
      value = "设置默认指定用户下指定类型下的权限",
      type = LogType.UPDATE
   )
   @RequestMapping(
      value = {"/{id}/user-permission-types/{permissionTypeId}/user-permissions/action/set-default"},
      method = {RequestMethod.PUT}
   )
   public void setDefaultUserPermission(@PathVariable String id, @PathVariable String permissionTypeId, RestJsonWrapperBean wrapper) {
      this.getService().setDefaultUserPermission(id, permissionTypeId, wrapper);
   }

   @Log(
      value = "电子签名",
      type = LogType.VALIDATE
   )
   @RequestMapping(
      value = {"/action/sign"},
      method = {RequestMethod.POST}
   )
   public CoreUserSignatureDTO sign(RestJsonWrapperBean wrapper) {
      return this.getService().sign(wrapper);
   }
}
