/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.user.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.mdm.user.bean.CoreUserPermissionBean;
import net.sinodawn.module.mdm.user.resource.CoreUserPermissionResource;
import net.sinodawn.module.mdm.user.service.CoreUserPermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@LogModule("用户权限")
@RestController
public class CoreUserPermissionResourceImpl implements CoreUserPermissionResource {
   @Autowired
   private CoreUserPermissionService userPermissionService;

   public CoreUserPermissionService getService() {
      return this.userPermissionService;
   }

   @Log(
      value = "查询指定类型下的权限",
      type = LogType.SELECT
   )
   @RequestMapping(
      value = {"/permission-types/{permissionTypeId}/queries"},
      method = {RequestMethod.POST}
   )
   public Page<CoreUserPermissionBean> selectPaginationByPermissionType(@PathVariable String permissionTypeId, RestJsonWrapperBean wrapper) {
      return this.getService().selectPaginationByPermissionType(permissionTypeId, wrapper);
   }

   @Log(
      value = "获取当前登录人员的角色",
      type = LogType.SELECT
   )
   public List<CoreUserPermissionBean> selectLoginRoleList(RestJsonWrapperBean wrapper) {
      return this.getService().selectLoginPermissionList(wrapper, "T_CORE_ROLE");
   }

   @Log(
      value = "获取当前登录人员的部门",
      type = LogType.SELECT
   )
   public List<CoreUserPermissionBean> selectLoginOrgList(RestJsonWrapperBean wrapper) {
      return this.getService().selectLoginPermissionList(wrapper, "T_CORE_ORG");
   }
}
