/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.user.resource;

import net.sinodawn.framework.restful.data.RestHttpTextEntity;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.bean.CoreUserSignatureDTO;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping({"/secure/core/module/mdm/users"})
public interface CoreUserResource extends GenericResource<CoreUserService, CoreUserBean, String> {
   @RequestMapping(
      value = {"/current-user/action/change-password"},
      method = {RequestMethod.PUT}
   )
   RestHttpTextEntity changePassword(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/current-user/action/change-new-password"},
      method = {RequestMethod.PUT}
   )
   RestHttpTextEntity changeNewPassword(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/action/change-password"},
      method = {RequestMethod.PUT}
   )
   RestHttpTextEntity changePassword(String id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      method = {RequestMethod.POST}
   )
   String insert(RestJsonWrapperBean wrapper);

   @ResponseStatus(HttpStatus.OK)
   @RequestMapping(
      value = {"/action/password-reset"},
      method = {RequestMethod.PUT}
   )
   void resetPassword(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/action/deprecate"},
      method = {RequestMethod.PUT}
   )
   void deprecate(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/queries/selected"},
      method = {RequestMethod.POST}
   )
   void insertUserPermission(String id, String permissionTypeId, RestJsonWrapperBean wrapper);

   void deleteUserPermission(String id, String permissionTypeId, RestJsonWrapperBean wrapper);

   void setDefaultUserPermission(String id, String permissionTypeId, RestJsonWrapperBean wrapper);

   CoreUserSignatureDTO sign(RestJsonWrapperBean wrapper);
}
