/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.user.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.mdm.user.bean.CoreUserPermissionBean;
import net.sinodawn.module.mdm.user.service.CoreUserPermissionService;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping({"/secure/core/module/mdm/user-permissions"})
public interface CoreUserPermissionResource extends GenericResource<CoreUserPermissionService, CoreUserPermissionBean, Long> {
   Page<CoreUserPermissionBean> selectPaginationByPermissionType(String permissionTypeId, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/login-role/queries/post-selectable"},
      method = {RequestMethod.POST}
   )
   List<CoreUserPermissionBean> selectLoginRoleList(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/login-org/queries/post-selectable"},
      method = {RequestMethod.POST}
   )
   List<CoreUserPermissionBean> selectLoginOrgList(RestJsonWrapperBean wrapper);
}
