/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.user.bean;

import com.alibaba.fastjson.annotation.JSONField;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractPersistable;
import net.sinodawn.framework.support.domain.Persistable;
import net.sinodawn.framework.support.domain.Suspendable;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Table("T_CORE_USER_PERMISSION_TYPE")
public class CoreUserPermissionTypeBean extends AbstractPersistable<String> implements Persistable<String>, Suspendable<String> {
   @Transient
   private static final long serialVersionUID = 929450267646962954L;
   @Id
   private String id;
   private String typeName;
   private String permissionType;
   private String gridChooseUrl;
   private String gridQueryUrl;
   private String gridColumnSettings;
   private String orderNo;
   @NotNull(
      defaultValue = "0"
   )
   private String lastSuspendedFlag;
   private String lastSuspendedById;
   private String lastSuspendedByName;
   @JSONField(
      format = "yyyy-MM-dd"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime lastSuspendedTime;

   public String getId() {
      return this.id;
   }

   public void setId(String id) {
      this.id = id;
   }

   public String getTypeName() {
      return this.typeName;
   }

   public void setTypeName(String typeName) {
      this.typeName = typeName;
   }

   public String getPermissionType() {
      return this.permissionType;
   }

   public void setPermissionType(String permissionType) {
      this.permissionType = permissionType;
   }

   public String getGridChooseUrl() {
      return this.gridChooseUrl;
   }

   public void setGridChooseUrl(String gridChooseUrl) {
      this.gridChooseUrl = gridChooseUrl;
   }

   public String getGridQueryUrl() {
      return this.gridQueryUrl;
   }

   public void setGridQueryUrl(String gridQueryUrl) {
      this.gridQueryUrl = gridQueryUrl;
   }

   public String getGridColumnSettings() {
      return this.gridColumnSettings;
   }

   public void setGridColumnSettings(String gridColumnSettings) {
      this.gridColumnSettings = gridColumnSettings;
   }

   public String getOrderNo() {
      return this.orderNo;
   }

   public void setOrderNo(String orderNo) {
      this.orderNo = orderNo;
   }

   public String getLastSuspendedFlag() {
      return this.lastSuspendedFlag;
   }

   public void setLastSuspendedFlag(String lastSuspendedFlag) {
      this.lastSuspendedFlag = lastSuspendedFlag;
   }

   public String getLastSuspendedById() {
      return this.lastSuspendedById;
   }

   public void setLastSuspendedById(String lastSuspendedById) {
      this.lastSuspendedById = lastSuspendedById;
   }

   public String getLastSuspendedByName() {
      return this.lastSuspendedByName;
   }

   public void setLastSuspendedByName(String lastSuspendedByName) {
      this.lastSuspendedByName = lastSuspendedByName;
   }

   public LocalDateTime getLastSuspendedTime() {
      return this.lastSuspendedTime;
   }

   public void setLastSuspendedTime(LocalDateTime lastSuspendedTime) {
      this.lastSuspendedTime = lastSuspendedTime;
   }
}
