/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.user.bean;

import org.springframework.data.annotation.Id;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import org.springframework.data.annotation.Transient;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;

@Table("T_CORE_USER_PERMISSION")
public class CoreUserPermissionBean extends AbstractInsertable<Long> implements Insertable<Long> {
   @Transient
   private static final long serialVersionUID = 929450267646962954L;
   @Id
   private Long id;
   private String userId;
   private String targetId;
   private String permissionTypeId;
   @NotNull(
      defaultValue = "0"
   )
   private String defaultFlag;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public String getUserId() {
      return this.userId;
   }

   public void setUserId(String userId) {
      this.userId = userId;
   }

   public String getDefaultFlag() {
      return this.defaultFlag;
   }

   public void setDefaultFlag(String defaultFlag) {
      this.defaultFlag = defaultFlag;
   }

   public String getTargetId() {
      return this.targetId;
   }

   public void setTargetId(String targetId) {
      this.targetId = targetId;
   }

   public String getPermissionTypeId() {
      return this.permissionTypeId;
   }

   public void setPermissionTypeId(String permissionTypeId) {
      this.permissionTypeId = permissionTypeId;
   }
}
