/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.user.bean;


import com.alibaba.fastjson.annotation.JSONField;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import net.sinodawn.framework.support.domain.AbstractInsertable;
import net.sinodawn.framework.support.domain.Insertable;
import net.sinodawn.framework.support.domain.Suspendable;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;

@Table("T_CORE_USER")
public class CoreUserBean extends AbstractInsertable<String> implements Insertable<String>, Suspendable<String> {
    @Transient
    private static final long serialVersionUID = -7191529835633871340L;
    @Id
    private String id;
    private String userNo;
    private String userName;
    @JSONField(
            serialize = false
    )
    private String password;
    private String mobile;
    private String email;
    private String idCard;
    private String status;
    private String orgId;
    private String orgName;
    @NotNull(
            defaultValue = "normal"
    )
    private String userType;
    @JSONField(
            format = "yyyy-MM-dd"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private LocalDateTime expiryDate;
    @NotNull(
            defaultValue = "0"
    )
    private Integer failedLoginAttempts;
    @NotNull
    @JSONField(
            format = "yyyy-MM-dd"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private LocalDateTime passwordUpdatedTime;
    @NotNull(
            defaultValue = "0"
    )
    private Integer expiredPasswordUses;
    @NotNull(
            defaultValue = "0"
    )
    private String multiLogin;
    @NotNull(
            defaultValue = "0"
    )
    private String lastSuspendedFlag;
    private String lastSuspendedById;
    private String lastSuspendedByName;
    @JSONField(
            format = "yyyy-MM-dd"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    private LocalDateTime lastSuspendedTime;

    public CoreUserBean() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserNo() {
        return this.userNo;
    }

    public void setUserNo(String userNo) {
        this.userNo = userNo;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getIdCard() {
        return this.idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public void setFailedLoginAttempts(Integer failedLoginAttempts) {
        this.failedLoginAttempts = failedLoginAttempts;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getLastSuspendedFlag() {
        return this.lastSuspendedFlag;
    }

    public void setLastSuspendedFlag(String lastSuspendedFlag) {
        this.lastSuspendedFlag = lastSuspendedFlag;
    }

    public Integer getExpiredPasswordUses() {
        return this.expiredPasswordUses;
    }

    public void setExpiredPasswordUses(Integer expiredPasswordUses) {
        this.expiredPasswordUses = expiredPasswordUses;
    }

    public LocalDateTime getPasswordUpdatedTime() {
        return this.passwordUpdatedTime;
    }

    public void setPasswordUpdatedTime(LocalDateTime passwordUpdatedTime) {
        this.passwordUpdatedTime = passwordUpdatedTime;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public String getMultiLogin() {
        return this.multiLogin;
    }

    public void setMultiLogin(String multiLogin) {
        this.multiLogin = multiLogin;
    }

    public String getLastSuspendedById() {
        return this.lastSuspendedById;
    }

    public void setLastSuspendedById(String lastSuspendedById) {
        this.lastSuspendedById = lastSuspendedById;
    }

    public String getLastSuspendedByName() {
        return this.lastSuspendedByName;
    }

    public void setLastSuspendedByName(String lastSuspendedByName) {
        this.lastSuspendedByName = lastSuspendedByName;
    }

    public LocalDateTime getLastSuspendedTime() {
        return this.lastSuspendedTime;
    }

    public void setLastSuspendedTime(LocalDateTime lastSuspendedTime) {
        this.lastSuspendedTime = lastSuspendedTime;
    }

    public LocalDateTime getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(LocalDateTime expiryDate) {
        this.expiryDate = expiryDate;
    }
}
