/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.org.validator;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.mybatis.mapper.MatchPattern;
import net.sinodawn.framework.mybatis.mapper.SearchFilter;
import net.sinodawn.framework.utils.ClassUtils;
import net.sinodawn.framework.utils.ReflectionUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.validator.permission.PermissionValidator;
import net.sinodawn.module.mdm.org.bean.CoreOrgBean;
import net.sinodawn.module.mdm.org.service.CoreOrgService;
import net.sinodawn.module.sys.metadata.bean.CoreTableHierarchyBean;
import net.sinodawn.module.sys.metadata.bean.CoreTablePermissionBean;
import net.sinodawn.module.sys.metadata.service.CoreTableService;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CoreOrgDeleteValidator implements PermissionValidator {
   @Autowired
   private CoreTableService tableService;

   public boolean doValid(String table, String category, Object id) {
      String loopTable = table;

      while(loopTable != null) {
         CoreTablePermissionBean tablePermission = this.tableService.selectTablePermission(loopTable, category);
         if (tablePermission != null && !this.checkPermission(tablePermission, id)) {
            return false;
         }

         CoreTableHierarchyBean tableHierarchy = this.tableService.selectTableHierarchy(loopTable, id);
         if (tableHierarchy == null) {
            loopTable = null;
         } else {
            loopTable = tableHierarchy.getMasterTableName();
            id = this.tableService.selectMasterId(tableHierarchy, (Serializable)id);
         }
      }

      CoreOrgService coreOrgService = (CoreOrgService)ApplicationContextHelper.getBean(CoreOrgService.class);
      List<CoreOrgBean> orgList = coreOrgService.selectListByFilter(SearchFilter.instance().match("PARENTID", id).filter(MatchPattern.EQ), new Order[0]);
      if (!orgList.isEmpty()) {
         this.addConstraintViolation("CORE.MODULE.MDM.ORGS.TIP.FORBID-DELETE");
         return false;
      } else {
         return true;
      }
   }

   private boolean checkPermission(CoreTablePermissionBean tablePermission, Object id) {
      if ("1".equals(tablePermission.getCheckUpdatable())) {
         Object service = ApplicationContextHelper.getBean(ClassUtils.getClass(tablePermission.getServiceClass()));
         if (!StringUtils.isEmpty(tablePermission.getCheckUpdatableMethod())) {
            Method checkUpdatableMethod = ReflectionUtils.findMethodWithReturnType(service.getClass(), tablePermission.getCheckUpdatableMethod(), Boolean.TYPE);
            if (checkUpdatableMethod == null) {
               logger.warn("Not specified check updatable method in table permission with table:" + tablePermission.getTableName() + " and category: " + tablePermission.getCategory() + ".");
            } else if (!(Boolean)ReflectionUtils.invokeMethod(checkUpdatableMethod, service, id)) {
               this.addConstraintViolation("core.validator.unauthorized.noupdatable");
               return false;
            }
         }
      }

      return true;
   }
}
