/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.org.service;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.mdm.org.bean.CoreOrgUserBean;
import java.util.List;

public interface CoreOrgUserService extends GenericService<CoreOrgUserBean, Long> {
   Page<CoreOrgUserBean> selectPaginationByOrg(String orgId, RestJsonWrapperBean wrapper);

   default Page<CoreOrgUserBean> selectPaginationByOrg(String orgId) {
      return this.selectPaginationByOrg(orgId, (RestJsonWrapperBean)null);
   }

   void deleteByUserId(String userId, String... orgIds);

   void insertByUserId(String userId, List<CoreOrgUserBean> orgUserList);
}
