/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.org.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.validator.permission.annotation.ValidatePermissionWith;
import net.sinodawn.module.mdm.org.bean.CoreOrgBean;
import net.sinodawn.module.mdm.org.bean.CoreOrgUserBean;
import net.sinodawn.module.mdm.org.resource.CoreOrgResource;
import net.sinodawn.module.mdm.org.service.CoreOrgService;
import net.sinodawn.module.mdm.org.service.CoreOrgUserService;
import net.sinodawn.module.mdm.org.validator.CoreOrgDeleteValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@LogModule("系统组织")
@RestController
public class CoreOrgResourceImpl implements CoreOrgResource {
   @Autowired
   private CoreOrgService orgService;
   @Autowired
   private CoreOrgUserService orgUserService;

   public CoreOrgService getService() {
      return this.orgService;
   }

   @Log(
      value = "当前角色下的已分配单位查询",
      type = LogType.SELECT
   )
   public Page<CoreOrgBean> selectRoleOrgList(@PathVariable Long roleId, RestJsonWrapperBean wrapper) {
      return this.getService().selectRoleOrgList(roleId, wrapper);
   }

   @Log(
      value = "新增",
      type = LogType.INSERT
   )
   @RequestMapping(
      method = {RequestMethod.POST}
   )
   public String insert(RestJsonWrapperBean wrapper) {
      return this.getService().insert(wrapper);
   }

   @Log(
      value = "新增“组织成员”",
      type = LogType.INSERT
   )
   public void insertOrgUser(@PathVariable String id, RestJsonWrapperBean wrapper) {
      this.getService().insertUser(id, wrapper);
   }

   @Log(
      value = "删除“组织成员”",
      type = LogType.DELETE
   )
   public void deleteOrgUser(@PathVariable String id, RestJsonWrapperBean wrapper) {
      this.getService().deleteUser(id, wrapper);
   }

   @Log(
      value = "通过组织机构查询“组织成员”",
      type = LogType.SELECT
   )
   public Page<CoreOrgUserBean> selectOrgUserPaginationByOrg(@PathVariable String id, RestJsonWrapperBean wrapper) {
      return this.orgUserService.selectPaginationByOrg(id, wrapper);
   }

   @Log(
      value = "通过组织机构查询“组织成员”",
      type = LogType.SELECT
   )
   public Page<CoreOrgUserBean> selectOrgUserPagination(RestJsonWrapperBean wrapper) {
      return this.orgUserService.selectRawPagination(wrapper);
   }

   @Log(
      value = "删除“组织成员”",
      type = LogType.DELETE
   )
   public void deleteOrgUser(RestJsonWrapperBean wrapper) {
      this.orgUserService.delete(wrapper);
   }

   @Log(
      value = "删除",
      type = LogType.DELETE
   )
   @RequestMapping(
      method = {RequestMethod.DELETE}
   )
   @ValidatePermissionWith(
      value = CoreOrgDeleteValidator.class,
      table = "#this.getService().getDao().getTable()"
   )
   public void delete(RestJsonWrapperBean wrapper) {
      this.getService().delete(wrapper);
   }
}
