/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.org.resource;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.resource.GenericResource;
import net.sinodawn.module.mdm.org.bean.CoreOrgBean;
import net.sinodawn.module.mdm.org.bean.CoreOrgUserBean;
import net.sinodawn.module.mdm.org.service.CoreOrgService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping({"/secure/core/module/mdm/orgs"})
public interface CoreOrgResource extends GenericResource<CoreOrgService, CoreOrgBean, String> {
   String insert(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/by-roles/{roleId}/queries"},
      method = {RequestMethod.POST}
   )
   Page<CoreOrgBean> selectRoleOrgList(@PathVariable Long roleId, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/users"},
      method = {RequestMethod.POST}
   )
   void insertOrgUser(String id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/users"},
      method = {RequestMethod.DELETE}
   )
   void deleteOrgUser(String id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/{id}/users/queries"},
      method = {RequestMethod.POST}
   )
   Page<CoreOrgUserBean> selectOrgUserPaginationByOrg(String id, RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/users/queries"},
      method = {RequestMethod.POST}
   )
   Page<CoreOrgUserBean> selectOrgUserPagination(RestJsonWrapperBean wrapper);

   @RequestMapping(
      value = {"/core-user-orgs/action/delete"},
      method = {RequestMethod.DELETE}
   )
   void deleteOrgUser(RestJsonWrapperBean wrapper);
}
