/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.org.bean;

import com.alibaba.fastjson.annotation.JSONField;
import org.springframework.data.annotation.Id;
import net.sinodawn.framework.data.annotation.NotNull;
import net.sinodawn.framework.data.annotation.Table;
import org.springframework.data.annotation.Transient;
import net.sinodawn.framework.support.domain.AbstractPersistable;
import net.sinodawn.framework.support.domain.Insertable;
import java.time.LocalDateTime;
import org.springframework.format.annotation.DateTimeFormat;

@Table("T_CORE_ORG_USER")
public class CoreOrgUserBean extends AbstractPersistable<Long> implements Insertable<Long> {
   @Transient
   private static final long serialVersionUID = 8785893939173304607L;
   @Id
   private Long id;
   private String orgId;
   private String orgName;
   private String userId;
   private String userName;
   @NotNull(
      defaultValue = "0"
   )
   private String defaultFlag;
   private String createdById;
   private String createdByName;
   @JSONField(
      format = "yyyy-MM-dd"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime createdTime;
   private String createdByOrgId;
   private String createdByOrgName;

   public Long getId() {
      return this.id;
   }

   public void setId(Long id) {
      this.id = id;
   }

   public String getOrgId() {
      return this.orgId;
   }

   public void setOrgId(String orgId) {
      this.orgId = orgId;
   }

   public String getOrgName() {
      return this.orgName;
   }

   public void setOrgName(String orgName) {
      this.orgName = orgName;
   }

   public String getUserId() {
      return this.userId;
   }

   public void setUserId(String userId) {
      this.userId = userId;
   }

   public String getUserName() {
      return this.userName;
   }

   public void setUserName(String userName) {
      this.userName = userName;
   }

   public String getDefaultFlag() {
      return this.defaultFlag;
   }

   public void setDefaultFlag(String defaultFlag) {
      this.defaultFlag = defaultFlag;
   }

   public String getCreatedById() {
      return this.createdById;
   }

   public void setCreatedById(String createdById) {
      this.createdById = createdById;
   }

   public String getCreatedByName() {
      return this.createdByName;
   }

   public void setCreatedByName(String createdByName) {
      this.createdByName = createdByName;
   }

   public LocalDateTime getCreatedTime() {
      return this.createdTime;
   }

   public void setCreatedTime(LocalDateTime createdTime) {
      this.createdTime = createdTime;
   }

   public String getCreatedByOrgId() {
      return this.createdByOrgId;
   }

   public void setCreatedByOrgId(String createdByOrgId) {
      this.createdByOrgId = createdByOrgId;
   }

   public String getCreatedByOrgName() {
      return this.createdByOrgName;
   }

   public void setCreatedByOrgName(String createdByOrgName) {
      this.createdByOrgName = createdByOrgName;
   }
}
