/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.org.bean;

import com.alibaba.fastjson.annotation.JSONField;
import org.springframework.data.annotation.Id;
import net.sinodawn.framework.data.annotation.Table;
import org.springframework.data.annotation.Transient;
import net.sinodawn.framework.support.domain.AbstractPersistable;
import net.sinodawn.framework.support.domain.Insertable;
import java.time.LocalDateTime;
import org.springframework.format.annotation.DateTimeFormat;

@Table("T_CORE_ORG")
public class CoreOrgBean extends AbstractPersistable<String> implements Insertable<String> {
   @Transient
   private static final long serialVersionUID = -82566196618711043L;
   @Id
   private String id;
   private String orgName;
   private String parentId;
   private String orgCategory;
   private String bizCode;
   private String orgProperty;
   private Long orderNo;
   private String createdById;
   private String createdByName;
   @JSONField(
      format = "yyyy-MM-dd"
   )
   @DateTimeFormat(
      pattern = "yyyy-MM-dd HH:mm:ss"
   )
   private LocalDateTime createdTime;
   private String createdByOrgId;
   private String createdByOrgName;

   public String getId() {
      return this.id;
   }

   public void setId(String id) {
      this.id = id;
   }

   public String getOrgName() {
      return this.orgName;
   }

   public void setOrgName(String orgName) {
      this.orgName = orgName;
   }

   public String getParentId() {
      return this.parentId;
   }

   public void setParentId(String parentId) {
      this.parentId = parentId;
   }

   public String getOrgCategory() {
      return this.orgCategory;
   }

   public void setOrgCategory(String orgCategory) {
      this.orgCategory = orgCategory;
   }

   public String getBizCode() {
      return this.bizCode;
   }

   public void setBizCode(String bizCode) {
      this.bizCode = bizCode;
   }

   public String getOrgProperty() {
      return this.orgProperty;
   }

   public void setOrgProperty(String orgProperty) {
      this.orgProperty = orgProperty;
   }

   public Long getOrderNo() {
      return this.orderNo;
   }

   public void setOrderNo(Long orderNo) {
      this.orderNo = orderNo;
   }

   public String getCreatedById() {
      return this.createdById;
   }

   public void setCreatedById(String createdById) {
      this.createdById = createdById;
   }

   public String getCreatedByName() {
      return this.createdByName;
   }

   public void setCreatedByName(String createdByName) {
      this.createdByName = createdByName;
   }

   public LocalDateTime getCreatedTime() {
      return this.createdTime;
   }

   public void setCreatedTime(LocalDateTime createdTime) {
      this.createdTime = createdTime;
   }

   public String getCreatedByOrgId() {
      return this.createdByOrgId;
   }

   public void setCreatedByOrgId(String createdByOrgId) {
      this.createdByOrgId = createdByOrgId;
   }

   public String getCreatedByOrgName() {
      return this.createdByOrgName;
   }

   public void setCreatedByOrgName(String createdByOrgName) {
      this.createdByOrgName = createdByOrgName;
   }
}
