/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.login.service.impl;

import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.cache.redis.RedisHelper;
import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.database.sql.Order;
import net.sinodawn.framework.exception.InvalidDataException;
import net.sinodawn.framework.i18n.I18nHelper;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.security.authentication.AuthenticationHelper;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import net.sinodawn.module.mdm.user.service.CoreUserService;
import net.sinodawn.module.mdm.login.service.CoreUserPasswordService;
import net.sinodawn.module.sys.password.bean.CorePasswordHisBean;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;
import net.sinodawn.module.sys.password.service.CorePasswordHisService;
import net.sinodawn.module.sys.password.service.CorePasswordPolicyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;

@Repository
public class CoreUserPasswordServiceImpl implements CoreUserPasswordService {
   private static final int RETRIEVE_PASSWORD_EXPIRED_TIME = 600;
   private static final String RETRIEVE_PASSWORD_EXPIRED_REDIS_NAME = "RETRIEVE_PASSWORD";
   private static final String MAIL_PROTOCOL_TYPE = "sino.mail.protocol.type";
   @Autowired
   @Lazy
   private CoreUserService userService;
   @Autowired
   @Lazy
   private CorePasswordHisService passwordHisService;
   @Autowired
   @Lazy
   private CorePasswordPolicyService passwordPolicyService;
   @Autowired
   private PasswordEncoder passwordEncoder;

   public void sendEmail(String userId, String email) {
      CoreUserBean selectUser = new CoreUserBean();
      selectUser.setId(userId);
      selectUser.setEmail(email);
      CoreUserBean user = (CoreUserBean)this.userService.getDao().selectOneIfPresent(selectUser, new String[0]);
      if (user == null) {
         throw new InvalidDataException("RETRIEVE_PASSWORD.TIP.USERID_EMAIL_DOESNOT_MATACH");
      } else {
         String subject = I18nHelper.getMessage("RETRIEVE_PASSWORD_EMAIL.SUBJECT", new String[0]);
         String content = this.createEmailLink(user);

//         try {
//            if ("exchange".equals(ApplicationContextHelper.getEnvironment().getProperty("sino.mail.protocol.type"))) {
//               ExchangeMailHelper.sendHtmlMail(subject, content, Arrays.asList(email), new File[0]);
//            } else {
//               MailHelper.sendHtmlMail(subject, content, Arrays.asList(email), new File[0]);
//            }
//
//         } catch (Exception var8) {
//            var8.printStackTrace();
//            throw new InvalidDataException("RETRIEVE_PASSWORD.TIP.SEND_EMAIL_FAILED");
//         }
      }
   }

   public void validUrl(String userId, String key) {
      if (!key.equals(RedisHelper.get("RETRIEVE_PASSWORD", userId))) {
         throw new InvalidDataException("RETRIEVE_PASSWORD.TIP.USERID_EMAIL_DOESNOT_MATACH");
      }
   }

   @Transactional
   @AuditTrailEntry(AuditTrailType.UPDATE)
   @Audit("AUDIT.SAVE")
   public void resetPassword(RestJsonWrapperBean wrapper) {
      CoreUserBean user = (CoreUserBean)wrapper.parseUnique(CoreUserBean.class);
      this.passwordPolicyService.checkPassword(user.getId(), user.getPassword());
      user.setPassword(this.passwordEncoder.encode(user.getPassword()));
      user.setFailedLoginAttempts(0);
      user.setExpiredPasswordUses(0);
      user.setPasswordUpdatedTime(LocalDateTime.now());
      this.userService.getDao().update(user, new String[0]);
      String oldPassword = ((CoreUserBean)this.userService.selectById(user.getId())).getPassword();
      CorePasswordHisBean passwordHis = new CorePasswordHisBean();
      passwordHis.setId(ApplicationContextHelper.getNextIdentity());
      passwordHis.setUserId(user.getId());
      passwordHis.setPassword(oldPassword);
      this.passwordHisService.getDao().insert(passwordHis);
      this.userService.update(user);
      RedisHelper.evict("RETRIEVE_PASSWORD", user.getId());
   }

   public String validUserAndEmail(String userId, String email) {
      CoreUserBean selectUser = new CoreUserBean();
      selectUser.setId(userId);
      selectUser.setEmail(email);
      CoreUserBean user = (CoreUserBean)this.userService.getDao().selectOneIfPresent(selectUser, new String[0]);
      return user != null && email.equals(user.getEmail()) ? "1" : "0";
   }

   public CorePasswordPolicyBean selectPasswordPolicyByUserId(String userId) {
      return this.passwordPolicyService.selectMatchingPasswordPolicy(userId);
   }

   public String validateUserPassword(String userId, RestJsonWrapperBean wrapper) {
      if (LocalContextHelper.isUserLogin() && LocalContextHelper.getLoginUserId().equals(userId)) {
         CoreUserBean user = new CoreUserBean();
         user.setId(userId);
         user.setPassword(this.passwordEncoder.encode(AuthenticationHelper.getRawPassword(wrapper.getParamValue("password"))));
         List<CoreUserBean> userList = this.userService.getDao().selectList(user, new Order[0]);
         return userList.isEmpty() ? "0" : "1";
      } else {
         return "0";
      }
   }

   private String createEmailLink(CoreUserBean user) {
      String secretKey = UUID.randomUUID().toString();
      RedisHelper.put("RETRIEVE_PASSWORD", user.getId(), secretKey, 600);
      String url = ApplicationContextHelper.getEnvironment().getProperty("sino.app.url");
      String contextPath = ApplicationContextHelper.getEnvironment().getProperty("server.servlet.context-path");
      StringBuilder sb = (new StringBuilder(url)).append(StringUtils.isEmpty(contextPath) ? "" : contextPath).append("?userId=").append(user.getId()).append("&secretKey=").append(secretKey).append("#resetPassword");
      return I18nHelper.getMessage("RETRIEVE_PASSWORD_EMAIL.CONTENT", new String[]{sb.toString(), sb.toString()});
   }
}
