/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.login.resource.impl;

import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.mdm.login.resource.CoreUserPasswordResource;
import net.sinodawn.module.mdm.login.service.CoreUserPasswordService;
import net.sinodawn.module.sys.password.bean.CorePasswordPolicyBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@LogModule("密码重置")
@RestController
@RequestMapping({"/open/core/module/mdm/user-passwords"})
public class CoreUserPasswordResourceImpl implements CoreUserPasswordResource {
   @Autowired
   private CoreUserPasswordService userPasswordService;

   public CoreUserPasswordService getService() {
      return this.userPasswordService;
   }

   @Log(
      value = "发送密码重置邮件",
      type = LogType.EXPORT
   )
   public void sendEmail(String userId, String email) {
      this.getService().sendEmail(userId, email);
   }

   @Log(
      value = "查询密码要重置的用户信息",
      type = LogType.SELECT
   )
   public void validUrl(String userId, String key) {
      this.getService().validUrl(userId, key);
   }

   @Log(
      value = "设置用户密码",
      type = LogType.UPDATE
   )
   @ResponseStatus(HttpStatus.OK)
   public void resetUserPwd(RestJsonWrapperBean wrapper) {
      this.getService().resetPassword(wrapper);
   }

   @Log(
      value = "验证用户的密码",
      type = LogType.VALIDATE
   )
   public String validateUserPassword(@PathVariable String userId, RestJsonWrapperBean wrapper) {
      return this.getService().validateUserPassword(userId, wrapper);
   }

   @Log(
      value = "根据用户编码查询密码策略",
      type = LogType.SELECT
   )
   public CorePasswordPolicyBean selectPasswordPolicyByUserId(String userId) {
      return this.getService().selectPasswordPolicyByUserId(userId);
   }
}
