/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.login.resource.impl;

import net.sinodawn.framework.context.LocalContextHelper;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.mdm.login.resource.CoreLoginResource;
import net.sinodawn.module.mdm.login.service.CoreLoginService;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@LogModule("用户登录")
@RestController
public class CoreLoginResourceImpl implements CoreLoginResource {
    @Autowired
    private CoreLoginService loginService;

    @Log(
            value = "查询当前用户登录信息",
            type = LogType.SELECT
    )
    public CoreUserBean getAccount() {
        return this.loginService.getAccount(LocalContextHelper.getLoginUserId());
    }

    @Log(
            value = "查询当前用户登录信息",
            type = LogType.SELECT
    )
    public CoreUserBean getAccount(String userId) {
        return this.loginService.getAccount(userId);
    }

    @Log(
            value = "验证用户登录的帐号和密码是否匹配",
            type = LogType.SELECT
    )
    public boolean checkAccount(RestJsonWrapperBean wrapper) {
        return this.loginService.checkAccount(wrapper);
    }

    @Log(
            value = "更新用户登录信息",
            type = LogType.UPDATE
    )
    public void updateLoginInfo(@RequestParam("orgId") String orgId, @RequestParam(name = "roleId",required = false) Long roleId) {
        this.loginService.updateLoginInfo(orgId, roleId);
    }
}
