/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.mdm.login.resource;

import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.module.mdm.user.bean.CoreUserBean;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping({"/core/module/sys/logins"})
public interface CoreLoginResource {

    @RequestMapping(
        value = {"/account"},
        method = {RequestMethod.GET}
    )
    CoreUserBean getAccount();

    @RequestMapping(
        value = {"/account/{userId}"},
        method = {RequestMethod.GET}
    )
    CoreUserBean getAccount(@PathVariable String userId);

    @RequestMapping(
        value = {"/action/check-account"},
        method = {RequestMethod.POST}
    )
    boolean checkAccount(RestJsonWrapperBean wrapper);

    @RequestMapping(
        method = {RequestMethod.PUT}
    )
    void updateLoginInfo(@RequestParam String orgId, @RequestParam(required = false) Long roleId);
}
