/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.item.file.validator;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.framework.utils.FileUtils;
import net.sinodawn.framework.utils.NumberUtils;
import net.sinodawn.framework.utils.StringUtils;
import net.sinodawn.framework.validator.data.DataValidator;
import java.util.Arrays;
import java.util.Objects;
import org.springframework.stereotype.Repository;
import org.springframework.web.multipart.MultipartFile;

@Repository
public class CoreFileUploadValidator implements DataValidator {
   public boolean doValid(Object... args) {
      MultipartFile file = (MultipartFile)Objects.requireNonNull((MultipartFile)args[1]);
      if (file != null && !file.isEmpty()) {
         String fileExt = FileUtils.getFileExtension(file.getOriginalFilename());
         if (StringUtils.isEmpty(fileExt)) {
            this.addConstraintViolation("SINO.FILE.TIP.NOTFILEEXTENSION");
            return false;
         } else {
            String validFileExtensions = ApplicationContextHelper.getConstantValue("FILE-EXTENSIONS");
            if (!Arrays.asList(StringUtils.split(validFileExtensions, ",")).contains(fileExt.toLowerCase())) {
               this.addConstraintViolation("SINO.FILE.TIP.UNSUPPORTEDEXTENSION");
               return false;
            } else {
               int spaceLimit = (Integer)NumberUtils.parseNumber(ApplicationContextHelper.getConstantValue("FILE-SPACELIMIT"), Integer.TYPE);
               if (spaceLimit == 0) {
                  spaceLimit = 100;
               }

               if (!file.isEmpty() && file.getSize() > (long)(spaceLimit * 1024 * 1024)) {
                  this.addConstraintViolation("SINO.FILE.TIP.FILELIMITEXCEEDED");
                  return false;
               } else {
                  return true;
               }
            }
         }
      } else {
         this.addConstraintViolation("SINO.FILE.TIP.NOTFILEUPLOAD");
         return false;
      }
   }
}
