/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.item.file.service.impl;

import net.sinodawn.framework.context.ApplicationContextHelper;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.bean.CoreFileImportResultDTO;
import net.sinodawn.module.item.file.function.CoreFileImportFunction;
import net.sinodawn.module.item.file.service.CoreFileImportService;
import net.sinodawn.module.item.file.service.CoreFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CoreFileImportServiceImpl implements CoreFileImportService {
   @Autowired
   private CoreFileService fileService;

   public CoreFileImportResultDTO importData(Long id, String service) {
      CoreFileImportFunction fileImportFunction = (CoreFileImportFunction)ApplicationContextHelper.getBean(service);
      CoreFileBean coreFile = this.fileService.selectDetail(id);
      if (fileImportFunction.test(coreFile, service)) {
         return (CoreFileImportResultDTO)fileImportFunction.apply(coreFile);
      } else {
         CoreFileImportResultDTO importResult = new CoreFileImportResultDTO();
         importResult.setMessage("SINO.FILE.IMPORT.TEMPLATE-MISMATCH");
         return importResult;
      }
   }
}
