/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.item.file.service;

import net.sinodawn.framework.at.annotation.AuditTrailEntry;
import net.sinodawn.framework.at.annotation.AuditTrailType;
import net.sinodawn.framework.audit.aunnotation.Audit;
import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.io.file.FilePathDTO;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericService;
import net.sinodawn.module.item.file.bean.CoreFileBean;
import net.sinodawn.module.item.file.bean.CoreFileCkeditorUploadResultDTO;
import net.sinodawn.module.item.file.bean.CoreFileLogBean;
import net.sinodawn.module.item.file.bean.CoreFileOfficeResultDTO;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.web.multipart.MultipartFile;

public interface CoreFileService extends GenericService<CoreFileBean, Long> {
   Page<CoreFileBean> selectSearchablePagination(RestJsonWrapperBean wrapper);

   @AuditTrailEntry(AuditTrailType.INSERT)
   @Audit("AUDIT.INSERT")
   Long upload(CoreFileBean coreFile, MultipartFile file);

   @AuditTrailEntry(AuditTrailType.INSERT)
   @Audit("AUDIT.INSERT")
   Long upload(CoreFileBean coreFile, File uploadFile);

   @AuditTrailEntry(AuditTrailType.INSERT)
   @Audit("AUDIT.INSERT")
   default Long upload(CoreFileBean coreFile, Path uploadPath) {
      return this.upload(coreFile, uploadPath.toFile());
   }

   <PK extends Serializable> List<CoreFileBean> selectFileList(String table, PK itemId);

   List<CoreFileBean> selectFileListByTargetIds(String... targetIds);

   void delete(RestJsonWrapperBean jsonWrapper);

   <PK extends Serializable> void delete(String table, PK itemId);

   void save(RestJsonWrapperBean jsonWrapper);

   String pack(String table, String itemId, String func);

   String pack(String table, RestJsonWrapperBean jsonWrapper);

   String pack(RestJsonWrapperBean jsonWrapper);

   CoreFileBean selectDetail(Long id);

   void copy(String fromTargetId, String toTargetId);

   void copy(String fromTargetId, Consumer<CoreFileBean> converter);

   CoreFileCkeditorUploadResultDTO ckeditorUpload(CoreFileBean coreFile, MultipartFile file);

   void deleteList(List<CoreFileBean> fileList);

   CoreFileOfficeResultDTO sinoOfficeInvoke(Long fileId);

   Page<CoreFileLogBean> selectLogSearchablePagination(Long id, RestJsonWrapperBean wrapper);

   String convertHtmlToPdf(RestJsonWrapperBean wrapper);

   void mergePdfList(List<FilePathDTO> sourcePdfList, FilePathDTO targetPdf);
}
