/*
 * Copyright (c) SinoDawn 2021.
 */

package net.sinodawn.module.item.file.resource.impl;

import net.sinodawn.framework.data.page.Page;
import net.sinodawn.framework.exception.UnsupportedException;
import net.sinodawn.framework.log.annotation.Log;
import net.sinodawn.framework.log.annotation.LogModule;
import net.sinodawn.framework.log.annotation.LogType;
import net.sinodawn.framework.restful.data.RestJsonWrapperBean;
import net.sinodawn.framework.support.base.service.GenericTemplateService;
import net.sinodawn.framework.validator.data.annotation.ValidateDataWith;
import net.sinodawn.module.item.file.bean.*;
import net.sinodawn.module.item.file.resource.CoreFileResource;
import net.sinodawn.module.item.file.service.CoreFileImportService;
import net.sinodawn.module.item.file.service.CoreFileLogService;
import net.sinodawn.module.item.file.service.CoreFileService;
import net.sinodawn.module.item.file.validator.CoreFileCKEditorUploadValidator;
import net.sinodawn.module.item.file.validator.CoreFileUploadValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.Serializable;

@LogModule("文件")
@RestController
public class CoreFileResourceImpl implements CoreFileResource {
   @Autowired
   private CoreFileService fileService;
   @Autowired
   private CoreFileLogService fileLogService;
   @Autowired
   private CoreFileImportService fileImportService;

   public CoreFileService getService() {
      return this.fileService;
   }

   @RequestMapping(
      method = {RequestMethod.TRACE}
   )
   public Long insert(RestJsonWrapperBean wrapper) {
      throw new UnsupportedException();
   }

   @Log(
      value = "上传",
      type = LogType.INSERT
   )
   @ValidateDataWith(CoreFileUploadValidator.class)
   public Long upload(CoreFileBean coreFile, MultipartFile file) {
      return this.getService().upload(coreFile, file);
   }

   @Log(
      value = "查询",
      type = LogType.SELECT
   )
   public Page<CoreFileBean> selectPagination(RestJsonWrapperBean wrapper) {
      return this.getService().selectSearchablePagination(wrapper);
   }

   @Log(
      value = "保存",
      type = LogType.UPDATE
   )
   @ResponseStatus(HttpStatus.OK)
   public void save(RestJsonWrapperBean jsonWrapper) {
      this.getService().save(jsonWrapper);
   }

   @Log(
      value = "删除",
      type = LogType.DELETE
   )
   @RequestMapping(
      method = {RequestMethod.DELETE}
   )
   @ResponseStatus(HttpStatus.OK)
   public void delete(RestJsonWrapperBean jsonWrapper) {
      this.getService().delete(jsonWrapper);
   }

   @ResponseStatus(HttpStatus.OK)
   @Log(
      value = "打包指定表下表单的附件，并返回下载的路径",
      type = LogType.EXPORT
   )
   public String pack(@PathVariable String table, @PathVariable String itemId, @PathVariable String func) {
      return this.getService().pack(table, itemId, func);
   }

   @ResponseStatus(HttpStatus.OK)
   @Log(
      value = "打包指定表的一个或多个表单的附件，并返回下载的路径",
      type = LogType.EXPORT
   )
   public String pack(@PathVariable String table, RestJsonWrapperBean jsonWrapper) {
      return this.getService().pack(table, jsonWrapper);
   }

   @ResponseStatus(HttpStatus.OK)
   @Log(
      value = "打包指定的一个或多个附件，并返回下载的路径",
      type = LogType.EXPORT
   )
   public String pack(RestJsonWrapperBean jsonWrapper) {
      return this.getService().pack(jsonWrapper);
   }

   @Log(
      value = "CKEDITOR上传图片",
      type = LogType.INSERT
   )
   @ValidateDataWith(CoreFileCKEditorUploadValidator.class)
   public CoreFileCkeditorUploadResultDTO ckeditorUpload(CoreFileBean coreFile, MultipartFile file) {
      return this.getService().ckeditorUpload(coreFile, file);
   }

   @Log(
      value = "通过附件编码导入数据",
      type = LogType.IMPORT
   )
   public CoreFileImportResultDTO importData(@PathVariable Long id, @PathVariable String service) {
      return this.fileImportService.importData(id, service);
   }

   @Log(
      value = "通过附件模板编码下载模板",
      type = LogType.EXPORT
   )
   public <ID extends Serializable> String getTemplateUrl(@RequestParam String templateCode, @RequestParam String service, @RequestParam(required = false) ID id) {
      return GenericTemplateService.getInstance(service).getDownloadUrl(templateCode, id);
   }

   @Log(
      value = "HTML内容转为PDF",
      type = LogType.UPDATE
   )
   public String convertHtmlToPdf(RestJsonWrapperBean wrapper) {
      return this.getService().convertHtmlToPdf(wrapper);
   }

   @Log(
      value = "SinoOffice操作",
      type = LogType.UPDATE
   )
   public CoreFileOfficeResultDTO sinoOfficeInvoke(@PathVariable Long id) {
      return this.getService().sinoOfficeInvoke(id);
   }

   @Log(
      value = "记录文件操作",
      type = LogType.EXPORT
   )
   public Long log(@PathVariable Long id, @PathVariable String operationCategory) {
      return this.fileLogService.insert(id, operationCategory);
   }

   @Log(
      value = "记录文件操作查询页查询",
      type = LogType.SELECT
   )
   public Page<CoreFileLogBean> selectLogSearchablePagination(@PathVariable Long id, RestJsonWrapperBean wrapper) {
      return this.getService().selectLogSearchablePagination(id, wrapper);
   }

   /** @deprecated */
   @Deprecated
   @Log(
      value = "通过附件模板编码下载模板（老方法，建议替换）",
      type = LogType.EXPORT
   )
   public <ID extends Serializable> String getDownloadTemplateUrl(@PathVariable String templateCode, @PathVariable String service, @PathVariable(required = false) ID id) {
      return this.getTemplateUrl(templateCode, service, id);
   }

   /** @deprecated */
   @Deprecated
   @Log(
      value = "记录文件操作（老方法，建议替换）",
      type = LogType.EXPORT
   )
   public Long oldLog(@PathVariable Long id, @PathVariable String operationCategory) {
      return this.fileLogService.insert(id, operationCategory);
   }

   /** @deprecated */
   @Deprecated
   @Log(
      value = "记录文件操作（老方法，建议替换）",
      type = LogType.EXPORT
   )
   public CoreFileOfficeResultDTO oldSinoOfficeInvoke(@PathVariable Long id) {
      return this.getService().sinoOfficeInvoke(id);
   }
}
